% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LSD.msdplot.r
\name{singlemsdplot}
\alias{singlemsdplot}
\alias{LSD.singlemsdplot}
\title{Visualize two-dimensional data clusters (add to an existing plot)}
\usage{
singlemsdplot(
  input,
  col = "darkgreen",
  alpha = 50,
  bars = TRUE,
  length = 0.25,
  at = NULL
)
}
\arguments{
\item{input}{data as matrix or list.}

\item{col}{a character vector of R build-in colors.}

\item{alpha}{alpha value: a two-digit integer between 01 and 99 for color opacity, i.e. appearance of partial or full transparency (usage omitted by default).}

\item{bars}{logical: if \code{TRUE} (by default), error bars are added at each position.}

\item{length}{a numeric value scaling the width of the bars.}

\item{at}{a integer vector containing the x-positions corresponding to the columns of 'input'.}
}
\description{
Depict a numeric matrix or list utilizing the underlying mean and standard deviation estimates of one dimension in a color encoded fashion (add to an existing plot).
}
\examples{
samples = 100
probes = 200
clus = matrix(rnorm(probes*samples,sd=1),ncol=probes)

clus = rbind(
	t(t(clus)+sin(1:probes/10))+1:nrow(clus)/samples,
	t(t(clus)+sin(pi/2+1:probes/10))+1:nrow(clus)/samples)

emptyplot(xlim = c(1,ncol(clus)),ylim = range(clus))
singlemsdplot(clus)
axis(1)
axis(2)
box()
}
\seealso{
\code{\link{comparisonplot}}, \code{\link{demotour}}, \code{\link{disco}}, \code{\link{colorpalette}}
}
\author{
Bjoern Schwalb
}
\keyword{mean}
\keyword{sd}
