% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnd-handlers.R
\name{catch_cnd}
\alias{catch_cnd}
\title{Catch a condition}
\usage{
catch_cnd(expr, classes = "condition")
}
\arguments{
\item{expr}{Expression to be evaluated with a catching condition
handler.}

\item{classes}{A character vector of condition classes to catch. By
default, catches all conditions.}
}
\value{
A condition if any was signalled, \code{NULL} otherwise.
}
\description{
This is a small wrapper around \code{tryCatch()} that captures any
condition signalled while evaluating its argument. It is useful for
situations where you expect a specific condition to be signalled,
for debugging, and for unit testing.
}
\examples{
catch_cnd(10)
catch_cnd(abort("an error"))
catch_cnd(signal("my_condition", message = "a condition"))
}
