% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_sp_country.R
\name{rl_sp_country}
\alias{rl_sp_country}
\alias{rl_sp_country_}
\title{Get species by country}
\usage{
rl_sp_country(country, key = NULL, parse = TRUE, ...)

rl_sp_country_(country, key = NULL, ...)
}
\arguments{
\item{country}{(character) A two-letter country code. See \code{isocode} column
in result of \code{\link[=rl_countries]{rl_countries()}} request for country codes.}

\item{key}{A IUCN API token. See
\url{http://apiv3.iucnredlist.org/api/v3/token} to get a token}

\item{parse}{(logical) Whether to parse to list (\code{FALSE}) or
data.frame (\code{TRUE}). Default: \code{TRUE}}

\item{...}{Curl options passed to \code{\link[crul]{HttpClient}}}
}
\value{
A list, with the data in the \code{result} slot, unless using
a function with a trailing underscore, in which case json as character
string is returned.
}
\description{
Get species by country
}
\examples{
\dontrun{
rl_sp_country('AZ')
rl_sp_country('NZ')

# don't parse to data.frame, gives list
rl_sp_country('NZ', parse = FALSE)
# don't parse at all, get json back
rl_sp_country_('NZ')

# curl options
res <- rl_sp_country('NZ', verbose = TRUE)
}
}
\references{
API docs at \url{http://apiv3.iucnredlist.org/api/v3/docs}
}
