% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{FindBridgeTransferAnchors}
\alias{FindBridgeTransferAnchors}
\title{Find bridge anchors between query and extended bridge-reference}
\usage{
FindBridgeTransferAnchors(
  extended.reference,
  query,
  query.assay = NULL,
  dims = 1:30,
  scale = FALSE,
  reduction = c("lsiproject", "pcaproject"),
  bridge.reduction = c("direct", "cca"),
  verbose = TRUE
)
}
\arguments{
\item{extended.reference}{BridgeReferenceSet object generated from
\code{\link{PrepareBridgeReference}}}

\item{query}{A query Seurat object}

\item{query.assay}{Assay name for query-bridge integration}

\item{dims}{Number of dimensions for query-bridge integration}

\item{scale}{Determine if scale the query data for projection}

\item{reduction}{Dimensional reduction to perform when finding anchors.
Options are:
\itemize{
   \item{pcaproject: Project the PCA from the bridge onto the query. We
   recommend using PCA when bridge and query datasets are from scRNA-seq}
   \item{lsiproject: Project the LSI from the bridge onto the query. We
   recommend using LSI when bridge and query datasets are from scATAC-seq or scCUT&TAG data.
   This requires that LSI or supervised LSI has been computed for the bridge dataset, and the
   same features (eg, peaks or genome bins) are present in both the bridge
   and query.
}
}}

\item{bridge.reduction}{Dimensional reduction to perform when finding anchors. Can
be one of:
\itemize{
  \item{cca: Canonical correlation analysis}
  \item{direct: Use assay data as a dimensional reduction}
}}

\item{verbose}{Print messages and progress}
}
\value{
Returns an \code{AnchorSet} object that can be used as input to
\code{\link{TransferData}}, \code{\link{IntegrateEmbeddings}} and
\code{\link{MapQuery}}.
}
\description{
Find a set of anchors between unimodal query and the other unimodal reference
using a pre-computed \code{\link{BridgeReferenceSet}}.
This function performs three steps:
1. Harmonize the bridge and query cells in the bridge query reduction space
2. Construct the bridge dictionary representations for query cells
3. Find a set of anchors between query and reference in the bridge graph laplacian eigenspace
These anchors can later be used to integrate embeddings or transfer data from the reference to
query object using the \code{\link{MapQuery}} object.
}
