% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename-files.R
\name{rename_files}
\alias{rename_files}
\title{Automatically rename paired \verb{R/} and \verb{test/} files}
\usage{
rename_files(old, new)
}
\arguments{
\item{old, new}{Old and new file names (with or without \code{.R} extensions).}
}
\description{
\itemize{
\item Moves \verb{R/\{old\}.R} to \verb{R/\{new\}.R}
\item Moves \verb{src/\{old\}.*} to \verb{src/\{new\}.*}
\item Moves \verb{tests/testthat/test-\{old\}.R} to \verb{tests/testthat/test-\{new\}.R}
\item Moves \verb{tests/testthat/test-\{old\}-*.*} to \verb{tests/testthat/test-\{new\}-*.*}
and updates paths in the test file.
\item Removes \code{context()} calls from the test file, which are unnecessary
(and discouraged) as of testthat v2.1.0.
}

This is a potentially dangerous operation, so you must be using Git in
order to use this function.
}
