# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2020 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "CardReader.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.idl

import raritan.rpc.smartcard


# interface
class CardReader(Interface):
    idlType = "smartcard.CardReader:1.0.2"

    NO_ERROR = 0

    ERR_SLOT_EMPTY = 1

    # structure
    class MetaData(Structure):
        idlType = "smartcard.CardReader_1_0_2.MetaData:1.0.0"
        elements = ["id", "manufacturer", "product", "serialNumber", "channel"]

        def __init__(self, id, manufacturer, product, serialNumber, channel):
            typecheck.is_string(id, AssertionError)
            typecheck.is_string(manufacturer, AssertionError)
            typecheck.is_string(product, AssertionError)
            typecheck.is_string(serialNumber, AssertionError)
            typecheck.is_int(channel, AssertionError)

            self.id = id
            self.manufacturer = manufacturer
            self.product = product
            self.serialNumber = serialNumber
            self.channel = channel

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                id = json['id'],
                manufacturer = json['manufacturer'],
                product = json['product'],
                serialNumber = json['serialNumber'],
                channel = json['channel'],
            )
            return obj

        def encode(self):
            json = {}
            json['id'] = self.id
            json['manufacturer'] = self.manufacturer
            json['product'] = self.product
            json['serialNumber'] = self.serialNumber
            json['channel'] = self.channel
            return json

    # structure
    class CardInformation(Structure):
        idlType = "smartcard.CardReader_1_0_2.CardInformation:1.0.0"
        elements = ["type", "uid"]

        def __init__(self, type, uid):
            typecheck.is_string(type, AssertionError)
            typecheck.is_string(uid, AssertionError)

            self.type = type
            self.uid = uid

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                type = json['type'],
                uid = json['uid'],
            )
            return obj

        def encode(self):
            json = {}
            json['type'] = self.type
            json['uid'] = self.uid
            return json

    # value object
    class CardEvent(raritan.rpc.idl.Event):
        idlType = "smartcard.CardReader_1_0_2.CardEvent:1.0.0"

        def __init__(self, cardInfo, source):
            super(raritan.rpc.smartcard.CardReader.CardEvent, self).__init__(source)
            typecheck.is_struct(cardInfo, raritan.rpc.smartcard.CardReader.CardInformation, AssertionError)

            self.cardInfo = cardInfo

        def encode(self):
            json = super(raritan.rpc.smartcard.CardReader.CardEvent, self).encode()
            json['cardInfo'] = raritan.rpc.smartcard.CardReader.CardInformation.encode(self.cardInfo)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                cardInfo = raritan.rpc.smartcard.CardReader.CardInformation.decode(json['cardInfo'], agent),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["cardInfo"]
            elements = elements + super(raritan.rpc.smartcard.CardReader.CardEvent, self).listElements()
            return elements

    # value object
    class CardInsertedEvent(CardEvent):
        idlType = "smartcard.CardReader_1_0_2.CardInsertedEvent:1.0.0"

        def __init__(self, cardInfo, source):
            super(raritan.rpc.smartcard.CardReader.CardInsertedEvent, self).__init__(cardInfo, source)

        def encode(self):
            json = super(raritan.rpc.smartcard.CardReader.CardInsertedEvent, self).encode()
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                # for smartcard.CardReader_1_0_2.CardEvent
                cardInfo = raritan.rpc.smartcard.CardReader.CardInformation.decode(json['cardInfo'], agent),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = []
            elements = elements + super(raritan.rpc.smartcard.CardReader.CardInsertedEvent, self).listElements()
            return elements

    # value object
    class CardRemovedEvent(CardEvent):
        idlType = "smartcard.CardReader_1_0_2.CardRemovedEvent:1.0.0"

        def __init__(self, cardInfo, source):
            super(raritan.rpc.smartcard.CardReader.CardRemovedEvent, self).__init__(cardInfo, source)

        def encode(self):
            json = super(raritan.rpc.smartcard.CardReader.CardRemovedEvent, self).encode()
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                # for smartcard.CardReader_1_0_2.CardEvent
                cardInfo = raritan.rpc.smartcard.CardReader.CardInformation.decode(json['cardInfo'], agent),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = []
            elements = elements + super(raritan.rpc.smartcard.CardReader.CardRemovedEvent, self).listElements()
            return elements

    class _getMetaData(Interface.Method):
        name = 'getMetaData'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.smartcard.CardReader.MetaData.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.smartcard.CardReader.MetaData, DecodeException)
            return _ret_

    class _getCardInformation(Interface.Method):
        name = 'getCardInformation'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            cardInfo = raritan.rpc.smartcard.CardReader.CardInformation.decode(rsp['cardInfo'], agent)
            typecheck.is_int(_ret_, DecodeException)
            typecheck.is_struct(cardInfo, raritan.rpc.smartcard.CardReader.CardInformation, DecodeException)
            return (_ret_, cardInfo)
    def __init__(self, target, agent):
        super(CardReader, self).__init__(target, agent)
        self.getMetaData = CardReader._getMetaData(self)
        self.getCardInformation = CardReader._getCardInformation(self)

#
# Section generated by IdlC from "CardReaderManager.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.idl

import raritan.rpc.smartcard


# interface
class CardReaderManager(Interface):
    idlType = "smartcard.CardReaderManager:1.0.2"

    # value object
    class CardReaderEvent(raritan.rpc.idl.Event):
        idlType = "smartcard.CardReaderManager_1_0_2.CardReaderEvent:1.0.0"

        def __init__(self, cardReader, source):
            super(raritan.rpc.smartcard.CardReaderManager.CardReaderEvent, self).__init__(source)
            typecheck.is_interface(cardReader, raritan.rpc.smartcard.CardReader, AssertionError)

            self.cardReader = cardReader

        def encode(self):
            json = super(raritan.rpc.smartcard.CardReaderManager.CardReaderEvent, self).encode()
            json['cardReader'] = Interface.encode(self.cardReader)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                cardReader = Interface.decode(json['cardReader'], agent),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["cardReader"]
            elements = elements + super(raritan.rpc.smartcard.CardReaderManager.CardReaderEvent, self).listElements()
            return elements

    # value object
    class CardReaderAttachedEvent(CardReaderEvent):
        idlType = "smartcard.CardReaderManager_1_0_2.CardReaderAttachedEvent:1.0.0"

        def __init__(self, cardReader, source):
            super(raritan.rpc.smartcard.CardReaderManager.CardReaderAttachedEvent, self).__init__(cardReader, source)

        def encode(self):
            json = super(raritan.rpc.smartcard.CardReaderManager.CardReaderAttachedEvent, self).encode()
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                # for smartcard.CardReaderManager_1_0_2.CardReaderEvent
                cardReader = Interface.decode(json['cardReader'], agent),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = []
            elements = elements + super(raritan.rpc.smartcard.CardReaderManager.CardReaderAttachedEvent, self).listElements()
            return elements

    # value object
    class CardReaderDetachedEvent(CardReaderEvent):
        idlType = "smartcard.CardReaderManager_1_0_2.CardReaderDetachedEvent:1.0.0"

        def __init__(self, cardReader, source):
            super(raritan.rpc.smartcard.CardReaderManager.CardReaderDetachedEvent, self).__init__(cardReader, source)

        def encode(self):
            json = super(raritan.rpc.smartcard.CardReaderManager.CardReaderDetachedEvent, self).encode()
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                # for smartcard.CardReaderManager_1_0_2.CardReaderEvent
                cardReader = Interface.decode(json['cardReader'], agent),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = []
            elements = elements + super(raritan.rpc.smartcard.CardReaderManager.CardReaderDetachedEvent, self).listElements()
            return elements

    class _getCardReaders(Interface.Method):
        name = 'getCardReaders'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_interface(x0, raritan.rpc.smartcard.CardReader, DecodeException)
            return _ret_

    class _getCardReaderById(Interface.Method):
        name = 'getCardReaderById'

        @staticmethod
        def encode(readerId):
            typecheck.is_string(readerId, AssertionError)
            args = {}
            args['readerId'] = readerId
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = Interface.decode(rsp['_ret_'], agent)
            typecheck.is_interface(_ret_, raritan.rpc.smartcard.CardReader, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(CardReaderManager, self).__init__(target, agent)
        self.getCardReaders = CardReaderManager._getCardReaders(self)
        self.getCardReaderById = CardReaderManager._getCardReaderById(self)
