#include "rheolef.h"
#include "rheolef/uzawa_abtb.h"
using namespace rheolef;
using namespace std;

Float u_upstream (const point& x) { return sqr(8.-x[0])/512.; }

int main(int argc, char**argv) {
  geo  omega (argv[1]);
  domain upstream = omega["upstream"];

  space X1h (omega, "P1", "vector");
  space Bh  (omega, "bubble", "vector");
  space Qh  (omega, "P1");
  space Wh  (omega, upstream, "P1");

  X1h.block ("wall");
  X1h.block ("upstream");
  X1h[0].block ("axis");
  X1h[0].block ("downstream");
  X1h[0].block ("axis");
  space Xh = X1h * Bh;

  field uh (Xh);
  field ph (Qh, 0.);
  uh[0]["wall"] = 0;
  uh[1]["wall"] = 0;
  uh[0]["upstream"] = 0;
  uh[1]["upstream"] = interpolate(Wh,u_upstream);
  uh[0]["downstream"] = 0;
  uh[0]["axis"] = 0;

  form a1 (X1h, X1h, "2D_D");
  form ab (Bh,  Bh,  "2D_D");
  form a0 = form_nul (Bh, X1h);
  form_manip a_manip;
  a_manip << size(2,2) 
          << a1        << a0
          << trans(a0) << ab;
  form a (Xh, Xh);
  a_manip >> a;

  form b1 = - form(X1h, Qh, "div");
  form bb = - form(Bh,  Qh, "div");
  form_manip b_manip;
  b_manip << size(1,2) 
          << b1 << bb;
  form b (Xh, Qh);
  b_manip >> b;

  int   max_iter  = 500;
  Float tol       = 1e-14;
  Float r         = 1e+7;
  form ar = a + r*trans(b)*b;
  ssk<Float> fact = ldlt(ar.uu);
  uzawa_abtb (ar.uu, fact, b.uu, uh.u, ph.u, -(ar.ub*uh.b), -(b.ub*uh.b), r, max_iter, tol);

  cout << catchmark("u")  << uh
       << catchmark("p")  << ph;
}
