#ifndef _RHEOLEF_UBLAS_INVERT_3X3_H
#define _RHEOLEF_UBLAS_INVERT_3X3_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

#include <boost/numeric/ublas/vector.hpp>
#include <boost/numeric/ublas/vector_proxy.hpp>
#include <boost/numeric/ublas/matrix.hpp>
#include <boost/numeric/ublas/triangular.hpp>
#include <boost/numeric/ublas/lu.hpp>
#include <boost/numeric/ublas/io.hpp>
namespace ublas = boost::numeric::ublas;

namespace rheolef { 
template<class T>
bool invert_3x3 (const ublas::matrix<T>& A, ublas::matrix<T>& result) {
  using namespace boost::numeric::ublas;
  T determinant =    +A(0,0)*(A(1,1)*A(2,2)-A(2,1)*A(1,2))
                     -A(0,1)*(A(1,0)*A(2,2)-A(1,2)*A(2,0))
                     +A(0,2)*(A(1,0)*A(2,1)-A(1,1)*A(2,0));
  if (1+determinant == 1) return false;
  T invdet = 1/determinant;
  result(0,0) =  (A(1,1)*A(2,2)-A(2,1)*A(1,2))*invdet;
  result(1,0) = -(A(0,1)*A(2,2)-A(0,2)*A(2,1))*invdet;
  result(2,0) =  (A(0,1)*A(1,2)-A(0,2)*A(1,1))*invdet;
  result(0,1) = -(A(1,0)*A(2,2)-A(1,2)*A(2,0))*invdet;
  result(1,1) =  (A(0,0)*A(2,2)-A(0,2)*A(2,0))*invdet;
  result(2,1) = -(A(0,0)*A(1,2)-A(1,0)*A(0,2))*invdet;
  result(0,2) =  (A(1,0)*A(2,1)-A(2,0)*A(1,1))*invdet;
  result(1,2) = -(A(0,0)*A(2,1)-A(2,0)*A(0,1))*invdet;
  result(2,2) =  (A(0,0)*A(1,1)-A(1,0)*A(0,1))*invdet;
  return true;
}
}// namespace rheolef
#endif // _RHEOLEF_UBLAS_INVERT_3X3_H
