require 'fog/core/model'

module Fog
  module Compute
    class XenServer
      class VIF < Fog::Model
        # API Reference here:
        # http://docs.vmd.citrix.com/XenServer/6.2.0/1.0/en_gb/api/?c=VIF

        identity :reference

        attribute :mac,                :aliases => :MAC
        attribute :uuid
        attribute :allowed_operations
        attribute :current_operations
        attribute :currently_attached
        attribute :device
        attribute :ipv4_allowed
        attribute :ipv6_allowed
        attribute :locking_mode
        attribute :mac_autogenerated,  :aliases => :MAC_autogenerated
        attribute :__metrics,          :aliases => :metrics
        attribute :other_config
        attribute :qos_algorithm_params
        attribute :qos_algorithm_type
        attribute :qos_supported_algorithms
        attribute :runtime_properties
        attribute :mtu,                :aliases => :MTU
        attribute :__network,          :aliases => :network
        attribute :status_code
        attribute :status_detail
        attribute :__vm,               :aliases => :VM

        def destroy
          service.destroy_vif reference
        end

        def network
          service.networks.get __network
        end

        def server
          service.servers.get __vm
        end

        def save
          requires :server
          raise ArgumentError.new('network is required for this operation') \
            unless attributes[:__network]
          ref = service.create_vif attributes[:server], attributes[:__network]
          merge_attributes service.vifs.get(ref).attributes
        end
      end
    end
  end
end
