= Joystick
* ((<Joystick Overview>))
* ((<SDL::Joystick>))
* Methods for Joystick 
  * ((<SDL::Joystick.num>)) -- Count available joysticks.
  * ((<SDL::Joystick.index_name>)) -- Get joystick name.
  * ((<SDL::Joystick.open>)) -- Opens a joystick for use.
  * ((<SDL::Joystick.open?>)) -- Determine if a joystick has been opened
  * ((<SDL::Joystick#index>)) -- Get the index of an joystick.
  * ((<SDL::Joystick#num_axes>)) -- Get the number of joystick axes
  * ((<SDL::Joystick#num_balls>)) -- Get the number of joystick trackballs
  * ((<SDL::Joystick#num_hats>)) -- Get the number of joystick hats
  * ((<SDL::Joystick#num_buttons>)) -- Get the number of joystick buttons
  * ((<SDL::Joystick.poll=>)) -- Enable/disable joystick event polling
  * ((<SDL::Joystick.poll>)) -- Gets the current state of joysick event polling
  * ((<SDL::Joystick.update_all>)) -- Updates the state of all joysticks
  * ((<SDL::Joystick#axis>)) -- Get the current state of an axis
  * ((<SDL::Joystick#hat>)) -- Get the current state of a joystick hat
  * ((<SDL::Joystick#button>)) -- Get the current state of a given button
  * ((<SDL::Joystick#ball>)) -- Get relative trackball motion
  * ((<SDL::Joystick#close>)) -- Closes a previously opened joystick

== Joystick Overview
Joysticks, and other similar input devices, have a very 
strong role
in game playing and SDL provides comprehensive support for them.
Axes, Buttons, POV Hats and trackballs are all supported.

Joystick support is initialized
by passed the SDL::INIT_JOYSTICK flag
to ((<SDL.init>)). Once initilized joysticks must be opened
using ((<SDL::Joystick.open>)).

While using the functions describe in this secton 
may seem like the best way
to access and read from joysticks, in most cases they aren't.
Ideally joysticks should be read
using the ((<SDL::Event>)) system.
To enable this, you must set the joystick event processing state
with ((<SDL::Joystick.poll=>)).
Joysticks must be ((<opened|SDL::Joystick.open>))
before they can be used of course.

* NOTES

  If you are ((*not*)) handling the joystick
  via the event queue then you must explicitly 
  request a joystick update by calling ((<SDL::Joystick.update_all>)).

  Force Feedback is not yet support.

== SDL::Joystick
The class represents one joystick.

* ((<SDL::Joystick.num>)) -- Count available joysticks.
* ((<SDL::Joystick.index_name>)) -- Get joystick name.
* ((<SDL::Joystick.open>)) -- Opens a joystick for use.
* ((<SDL::Joystick.open?>)) -- Determine if a joystick has been opened
* ((<SDL::Joystick#index>)) -- Get the index of an joystick.
* ((<SDL::Joystick#num_axes>)) -- Get the number of joystick axes
* ((<SDL::Joystick#num_balls>)) -- Get the number of joystick trackballs
* ((<SDL::Joystick#num_hats>)) -- Get the number of joystick hats
* ((<SDL::Joystick#num_buttons>)) -- Get the number of joystick buttons
* ((<SDL::Joystick.poll=>)) -- Enable/disable joystick event polling
* ((<SDL::Joystick.poll>)) -- Gets the current state of joysick event polling
* ((<SDL::Joystick.update_all>)) -- Updates the state of all joysticks
* ((<SDL::Joystick#axis>)) -- Get the current state of an axis
* ((<SDL::Joystick#hat>)) -- Get the current state of a joystick hat
* ((<SDL::Joystick#button>)) -- Get the current state of a given button
* ((<SDL::Joystick#ball>)) -- Get relative trackball motion
* ((<SDL::Joystick#close>)) -- Closes a previously opened joystick

== Methods

--- SDL::Joystick.num

    Counts the number of joysticks attached to the system.

    * See Also
      
      ((<SDL::Joystick.index_name>)), ((<SDL::Joystick.open>))

--- SDL::Joystick.index_name(index)
--- SDL::Joystick.indexName(index)

    Get the implementation dependent name of joystick. 
    The ((|index|)) parameter
    refers to the N'th joystick on the system.


    EXAMPLE
      # Print the names of all attached joysticks
      num_joy = SDL::Joystick.num
      printf("%d joysticks found\n", num_joy)
      num_joy.times do |i|
        puts SDL::Joystick.index_name(i)
      end

    * See Also
      
      ((<SDL::Joystick.open>))

--- SDL::Joystick.open(index)

    Opens a joystick for use within SDL. The ((|index|)) refers to the N'th
    joystick in the system. A joystick must be opened before it can be
    used.

    Returns a ((<SDL::Joystick>)) instance on success.

    Raises ((<SDL::Error>)) on failure

    EXAMPLE
      # Check for joystick
      if SDL::Joystick.num > 0
        # Open joystick
        joy = SDL::Joystick.open(0)
      
        printf("Opened Joystick 0\n");
        printf("Name: %s\n", SDL::Joystick.name(0))
        printf("Number of Axes: %d\n", joy.num_axes)
        printf("Number of Buttons: %d\n", joy.num_buttons)
        printf("Number of Balls: %d\n", joy.num_balls)
      end  

--- SDL::Joystick.open?(index)

    Determines whether a joystick has already been opened within the
    application. ((|index|)) refers to the N'th joystick on the system.

    Returns true if the joystick has been opened, or false if it has not.

    * See Also
      
      ((<SDL::Joystick.open>))

--- SDL::Joystick#index

    Returns the index of ((|self|)).

--- SDL::Joystick#num_axes
--- SDL::Joystick#numAxes

    Return the number of axes available.

    * NOTES

      This method counts two dimensional axes as two axes.

    * See Also
      
      ((<SDL::Joystick#axis>))

--- SDL::Joystick#num_balls
--- SDL::Joystick#numBalls

    Return the number of trackballs available.

    * See Also
      
      ((<SDL::Joystick#ball>))

--- SDL::Joystick#num_hats
--- SDL::Joystick#numHats

    Return the number of hats available.

    * See Also
      
      ((<SDL::Joystick#hat>))

--- SDL::Joystick#num_buttons
--- SDL::Joystick#numButtons

    Return the number of buttons available.

    * See Also
      
      ((<SDL::Joystick#button>))

--- SDL::Joystick.poll=(enable)

    This function is used to enable or disable joystick event
    processing. With joystick event processing disabled you will have
    to update joystick states with ((<SDL::Joystick.update_all>)) and read the
    joystick information manually.
    
    Joystick event polling is enabled by default.
    
    NOTE
    Joystick event handling is preferred.
    
    Even if joystick event processing is enabled,
    individual joysticks must be opened before they generate
    events.
    
    Calling this method may delete all events
    currently in SDL's event queue.

    * See Also
      
      ((<SDL::Joystick.update_all>)), ((<SDL::Joystick.poll>)), ((<SDL::Event2::JoyAxis>)), ((<SDL::Event2::JoyBall>)), ((<SDL::Event2::JoyButtonDown>)), ((<SDL::Event2::JoyButtonUp>)), ((<SDL::Event2::JoyHat>))

--- SDL::Joystick.poll

    Returns true if joysick event polling is enabled, otherwise 
    returns false. You will also read ((<SDL::Joystick.poll=>)).

--- SDL::Joystick.update_all
--- SDL::Joystick.updateAll

    Updates the state(position, buttons, etc.) of all open joysticks.
    If joystick events have been enabled with ((<SDL::Joystick.poll=>))
    then this is called automatically in the event loop.

--- SDL::Joystick#axis(axis_index)

    Returns the current state of given ((|axis_index|)) on ((|self|)).
    
    On most modern joysticks the X axis is usually represented by
    axis 0 and the Y axis by axis 1. The value returned by
    this method is a signed integer (-32768 to 32767)
    representing the current position of the axis, it may be
    necessary to impose certain tolerances on these values to account
    for jitter.


    EXAMPLE
      joy = SDL::Joystick.open(0)
        .
        .
      x_move = joy.axis(0)
      y_move = joy.axis(1)

    * See Also
      
      ((<SDL::Joystick#num_axes>))

--- SDL::Joystick#hat(hat_index)

    Returns the current state of the given ((|hat_index|)).

    The current state is returned as a unsinged integer
    which is an OR'd combination of one or more of the following
    
    * SDL::Joystick::HAT_CENTERED
    * SDL::Joystick::HAT_UP
    * SDL::Joystick::HAT_RIGHT
    * SDL::Joystick::HAT_DOWN
    * SDL::Joystick::HAT_LEFT
    * SDL::Joystick::HAT_RIGHTUP
    * SDL::Joystick::HAT_RIGHTDOWN
    * SDL::Joystick::HAT_LEFTUP
    * SDL::Joystick::HAT_LEFTDOWN

    * See Also
      
      ((<SDL::Joystick#num_hats>))

--- SDL::Joystick#button(button_index)

    returns the current state of the given ((|button_index|)).
    Returns true if the button is pressed, otherwise returns false.

    * See Also
      
      ((<SDL::Joystick#num_buttons>))

--- SDL::Joystick#ball(ball_index)

    Get the ball axis change.
    Trackballs can only return relative motion since the last call to
    this method, these motion deltas are returned as 
    an array of two elements, [dx, dy].

    Raises ((<SDL::Error>)) on failure

    EXAMPLE
      delta_x, delta_y = joy.ball(0)
      printf("Trackball Delta- X:%d, Y:%d\n", delta_x, delta_y)

--- SDL::Joystick#close

    Close a joystick that was previously opened with ((<SDL::Joystick.open>)).

    * See Also
      
      ((<SDL::Joystick.open>)), ((<SDL::Joystick.open?>))

