/*
 * Decompiled with CFR 0.152.
 */
package app.authkit.test;

import app.authkit.test.AuthTest;
import glguerin.util.LibLoader;

public class TestLoader
extends AuthTest {
    private static String[] listProps = new String[]{"java.library.path", "sun.boot.library.path", "java.ext.dirs", "java.class.path", "java.home", "user.dir", "glguerin.util.LibLoader.imp"};

    public static void main(String[] stringArray) {
        AuthTest.tell("TestLoader.main(): starting...");
        LibLoader.isVerbose = true;
        TestLoader.tellProperties(listProps);
        LibLoader libLoader = LibLoader.makeLoader();
        AuthTest.tell("LibLoader class: " + libLoader.getClass().getName());
        AuthTest.tell("     loads from: " + libLoader.toString());
        AuthTest.tell("");
        int n = 0;
        while (n < stringArray.length) {
            TestLoader.tryLoading(libLoader, stringArray[n]);
            ++n;
        }
        AuthTest.tell("TestLoader.main(): done...\n");
    }

    public static void tryLoading(LibLoader libLoader, String string) {
        try {
            libLoader.loadLibrary(string);
            AuthTest.tell("Loaded: " + string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            AuthTest.tell("UnsatisfiedLinkError: " + string + " -- " + unsatisfiedLinkError.getMessage());
        }
        catch (Throwable throwable) {
            AuthTest.explain(throwable);
        }
        AuthTest.tell("");
    }

    public static void tellProperties(String[] stringArray) {
        AuthTest.tell("-- System properties...");
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            String string2 = System.getProperty(string, "<unknown>");
            AuthTest.tell("  " + string + " = " + string2);
            ++n;
        }
        AuthTest.tell("");
    }
}

