/* database-cursor.c generated by valac 0.36.6, the Vala compiler
 * generated from database-cursor.vala, do not modify */

/*
 * Copyright (C) 2011 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_DATABASE_TYPE_CURSOR (rygel_database_cursor_get_type ())
#define RYGEL_DATABASE_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_DATABASE_TYPE_CURSOR, RygelDatabaseCursor))
#define RYGEL_DATABASE_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_DATABASE_TYPE_CURSOR, RygelDatabaseCursorClass))
#define RYGEL_DATABASE_IS_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_DATABASE_TYPE_CURSOR))
#define RYGEL_DATABASE_IS_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_DATABASE_TYPE_CURSOR))
#define RYGEL_DATABASE_CURSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_DATABASE_TYPE_CURSOR, RygelDatabaseCursorClass))

typedef struct _RygelDatabaseCursor RygelDatabaseCursor;
typedef struct _RygelDatabaseCursorClass RygelDatabaseCursorClass;
typedef struct _RygelDatabaseCursorPrivate RygelDatabaseCursorPrivate;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_DATABASE_CURSOR_TYPE_ITERATOR (rygel_database_cursor_iterator_get_type ())
#define RYGEL_DATABASE_CURSOR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_DATABASE_CURSOR_TYPE_ITERATOR, RygelDatabaseCursorIterator))
#define RYGEL_DATABASE_CURSOR_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_DATABASE_CURSOR_TYPE_ITERATOR, RygelDatabaseCursorIteratorClass))
#define RYGEL_DATABASE_CURSOR_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_DATABASE_CURSOR_TYPE_ITERATOR))
#define RYGEL_DATABASE_CURSOR_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_DATABASE_CURSOR_TYPE_ITERATOR))
#define RYGEL_DATABASE_CURSOR_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_DATABASE_CURSOR_TYPE_ITERATOR, RygelDatabaseCursorIteratorClass))

typedef struct _RygelDatabaseCursorIterator RygelDatabaseCursorIterator;
typedef struct _RygelDatabaseCursorIteratorClass RygelDatabaseCursorIteratorClass;
typedef struct _RygelDatabaseCursorIteratorPrivate RygelDatabaseCursorIteratorPrivate;
typedef struct _RygelDatabaseCursorParamSpecIterator RygelDatabaseCursorParamSpecIterator;

struct _RygelDatabaseCursor {
	GObject parent_instance;
	RygelDatabaseCursorPrivate * priv;
};

struct _RygelDatabaseCursorClass {
	GObjectClass parent_class;
};

struct _RygelDatabaseCursorPrivate {
	sqlite3_stmt* statement;
	gint current_state;
	gboolean dirty;
	sqlite3* db;
};

typedef enum  {
	RYGEL_DATABASE_DATABASE_ERROR_SQLITE_ERROR,
	RYGEL_DATABASE_DATABASE_ERROR_OPEN,
	RYGEL_DATABASE_DATABASE_ERROR_PREPARE,
	RYGEL_DATABASE_DATABASE_ERROR_BIND,
	RYGEL_DATABASE_DATABASE_ERROR_STEP
} RygelDatabaseDatabaseError;
#define RYGEL_DATABASE_DATABASE_ERROR rygel_database_database_error_quark ()
struct _RygelDatabaseCursorIterator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelDatabaseCursorIteratorPrivate * priv;
	RygelDatabaseCursor* cursor;
};

struct _RygelDatabaseCursorIteratorClass {
	GTypeClass parent_class;
	void (*finalize) (RygelDatabaseCursorIterator *self);
};

struct _RygelDatabaseCursorParamSpecIterator {
	GParamSpec parent_instance;
};


static gpointer rygel_database_cursor_parent_class = NULL;
static gpointer rygel_database_cursor_iterator_parent_class = NULL;

GType rygel_database_cursor_get_type (void) G_GNUC_CONST;
#define RYGEL_DATABASE_CURSOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_DATABASE_TYPE_CURSOR, RygelDatabaseCursorPrivate))
enum  {
	RYGEL_DATABASE_CURSOR_DUMMY_PROPERTY
};
GQuark rygel_database_database_error_quark (void);
RygelDatabaseCursor* rygel_database_cursor_new (sqlite3* db, const gchar* sql, GValue* arguments, int arguments_length1, GError** error);
RygelDatabaseCursor* rygel_database_cursor_construct (GType object_type, sqlite3* db, const gchar* sql, GValue* arguments, int arguments_length1, GError** error);
void rygel_database_cursor_throw_if_code_is_error (RygelDatabaseCursor* self, gint sqlite_error, GError** error);
void rygel_database_cursor_bind (RygelDatabaseCursor* self, GValue* arguments, int arguments_length1, GError** error);
gboolean rygel_database_cursor_has_next (RygelDatabaseCursor* self, GError** error);
sqlite3_stmt* rygel_database_cursor_next (RygelDatabaseCursor* self, GError** error);
gpointer rygel_database_cursor_iterator_ref (gpointer instance);
void rygel_database_cursor_iterator_unref (gpointer instance);
GParamSpec* rygel_database_cursor_param_spec_iterator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_database_cursor_value_set_iterator (GValue* value, gpointer v_object);
void rygel_database_cursor_value_take_iterator (GValue* value, gpointer v_object);
gpointer rygel_database_cursor_value_get_iterator (const GValue* value);
GType rygel_database_cursor_iterator_get_type (void) G_GNUC_CONST;
RygelDatabaseCursorIterator* rygel_database_cursor_iterator (RygelDatabaseCursor* self);
RygelDatabaseCursorIterator* rygel_database_cursor_iterator_new (RygelDatabaseCursor* cursor);
RygelDatabaseCursorIterator* rygel_database_cursor_iterator_construct (GType object_type, RygelDatabaseCursor* cursor);
void rygel_database_cursor_throw_if_db_has_error (RygelDatabaseCursor* self, GError** error);
enum  {
	RYGEL_DATABASE_CURSOR_ITERATOR_DUMMY_PROPERTY
};
gboolean rygel_database_cursor_iterator_next (RygelDatabaseCursorIterator* self, GError** error);
sqlite3_stmt* rygel_database_cursor_iterator_get (RygelDatabaseCursorIterator* self, GError** error);
static void rygel_database_cursor_iterator_finalize (RygelDatabaseCursorIterator * obj);
static void rygel_database_cursor_finalize (GObject * obj);


/**
     * Prepare a SQLite statement from a SQL string
     *
     * If @arguments is non-null, it will call bind()
     *
     * @param db SQLite database this cursor belongs to
     * @param sql statement to execute
     * @param arguments array of values to bind to the SQL statement or null if
     * none
     */
RygelDatabaseCursor* rygel_database_cursor_construct (GType object_type, sqlite3* db, const gchar* sql, GValue* arguments, int arguments_length1, GError** error) {
	RygelDatabaseCursor * self = NULL;
	sqlite3* _tmp0_;
	sqlite3* _tmp1_;
	const gchar* _tmp2_;
	sqlite3_stmt* _tmp3_ = NULL;
	gint _tmp4_;
	GValue* _tmp5_;
	gint _tmp5__length1;
	GValue* _tmp6_;
	gint _tmp6__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (db != NULL, NULL);
	g_return_val_if_fail (sql != NULL, NULL);
	self = (RygelDatabaseCursor*) g_object_new (object_type, NULL);
	_tmp0_ = db;
	self->priv->db = _tmp0_;
	_tmp1_ = db;
	_tmp2_ = sql;
	_tmp4_ = sqlite3_prepare_v2 (_tmp1_, _tmp2_, -1, &_tmp3_, NULL);
	_sqlite3_finalize0 (self->priv->statement);
	self->priv->statement = _tmp3_;
	rygel_database_cursor_throw_if_code_is_error (self, _tmp4_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp5_ = arguments;
	_tmp5__length1 = arguments_length1;
	if (_tmp5_ == NULL) {
		return self;
	}
	_tmp6_ = arguments;
	_tmp6__length1 = arguments_length1;
	rygel_database_cursor_bind (self, _tmp6_, _tmp6__length1, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return self;
}


RygelDatabaseCursor* rygel_database_cursor_new (sqlite3* db, const gchar* sql, GValue* arguments, int arguments_length1, GError** error) {
	return rygel_database_cursor_construct (RYGEL_DATABASE_TYPE_CURSOR, db, sql, arguments, arguments_length1, error);
}


/**
     * Bind new values to a cursor.
     *
     * The cursor will be reset.
     *
     * This function uses the type of the GValue passed in values to determine
     * which _bind function to use.
     *
     * Supported types are: int, long, int64, uint64, string and pointer.
     * Note: The only pointer supported is the null pointer as provided by
     * Database.@null. This is a special value to bind a column to NULL
     * @param arguments array of values to bind to the SQL statement or null if
     * none
     */
void rygel_database_cursor_bind (RygelDatabaseCursor* self, GValue* arguments, int arguments_length1, GError** error) {
	sqlite3_stmt* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->statement;
	sqlite3_reset (_tmp0_);
	self->priv->dirty = TRUE;
	self->priv->current_state = -1;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				GValue* _tmp4_;
				gint _tmp4__length1;
				GValue current_value = {0};
				GValue* _tmp5_;
				gint _tmp5__length1;
				gint _tmp6_;
				GValue _tmp7_;
				gboolean _tmp8_;
				sqlite3* _tmp40_;
				gint _tmp41_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = arguments;
				_tmp4__length1 = arguments_length1;
				if (!(_tmp3_ <= _tmp4__length1)) {
					break;
				}
				_tmp5_ = arguments;
				_tmp5__length1 = arguments_length1;
				_tmp6_ = i;
				_tmp7_ = _tmp5_[_tmp6_ - 1];
				current_value = _tmp7_;
				_tmp8_ = G_VALUE_HOLDS (&current_value, G_TYPE_INT);
				if (_tmp8_) {
					sqlite3_stmt* _tmp9_;
					gint _tmp10_;
					gint _tmp11_;
					_tmp9_ = self->priv->statement;
					_tmp10_ = i;
					_tmp11_ = g_value_get_int (&current_value);
					sqlite3_bind_int (_tmp9_, _tmp10_, _tmp11_);
				} else {
					gboolean _tmp12_;
					_tmp12_ = G_VALUE_HOLDS (&current_value, G_TYPE_INT64);
					if (_tmp12_) {
						sqlite3_stmt* _tmp13_;
						gint _tmp14_;
						gint64 _tmp15_;
						_tmp13_ = self->priv->statement;
						_tmp14_ = i;
						_tmp15_ = g_value_get_int64 (&current_value);
						sqlite3_bind_int64 (_tmp13_, _tmp14_, _tmp15_);
					} else {
						gboolean _tmp16_;
						_tmp16_ = G_VALUE_HOLDS (&current_value, G_TYPE_UINT64);
						if (_tmp16_) {
							sqlite3_stmt* _tmp17_;
							gint _tmp18_;
							guint64 _tmp19_;
							_tmp17_ = self->priv->statement;
							_tmp18_ = i;
							_tmp19_ = g_value_get_uint64 (&current_value);
							sqlite3_bind_int64 (_tmp17_, _tmp18_, (gint64) _tmp19_);
						} else {
							gboolean _tmp20_;
							_tmp20_ = G_VALUE_HOLDS (&current_value, G_TYPE_LONG);
							if (_tmp20_) {
								sqlite3_stmt* _tmp21_;
								gint _tmp22_;
								glong _tmp23_;
								_tmp21_ = self->priv->statement;
								_tmp22_ = i;
								_tmp23_ = g_value_get_long (&current_value);
								sqlite3_bind_int64 (_tmp21_, _tmp22_, (gint64) _tmp23_);
							} else {
								gboolean _tmp24_;
								_tmp24_ = G_VALUE_HOLDS (&current_value, G_TYPE_UINT);
								if (_tmp24_) {
									sqlite3_stmt* _tmp25_;
									gint _tmp26_;
									guint _tmp27_;
									_tmp25_ = self->priv->statement;
									_tmp26_ = i;
									_tmp27_ = g_value_get_uint (&current_value);
									sqlite3_bind_int64 (_tmp25_, _tmp26_, (gint64) _tmp27_);
								} else {
									gboolean _tmp28_;
									_tmp28_ = G_VALUE_HOLDS (&current_value, G_TYPE_STRING);
									if (_tmp28_) {
										sqlite3_stmt* _tmp29_;
										gint _tmp30_;
										const gchar* _tmp31_;
										gchar* _tmp32_;
										GDestroyNotify _tmp33_;
										_tmp29_ = self->priv->statement;
										_tmp30_ = i;
										_tmp31_ = g_value_get_string (&current_value);
										_tmp32_ = g_strdup (_tmp31_);
										_tmp33_ = g_free;
										sqlite3_bind_text (_tmp29_, _tmp30_, _tmp32_, -1, _tmp33_);
									} else {
										gboolean _tmp34_;
										_tmp34_ = G_VALUE_HOLDS (&current_value, G_TYPE_POINTER);
										if (_tmp34_) {
											void* _tmp35_;
											_tmp35_ = g_value_peek_pointer (&current_value);
											if (_tmp35_ == NULL) {
												sqlite3_stmt* _tmp36_;
												gint _tmp37_;
												_tmp36_ = self->priv->statement;
												_tmp37_ = i;
												sqlite3_bind_null (_tmp36_, _tmp37_);
											} else {
												g_assert_not_reached ();
											}
										} else {
											GType type = 0UL;
											GType _tmp38_;
											const gchar* _tmp39_;
											_tmp38_ = G_VALUE_TYPE (&current_value);
											type = _tmp38_;
											_tmp39_ = g_type_name (type);
											g_warning (_ ("Unsupported type %s"), _tmp39_);
											g_assert_not_reached ();
										}
									}
								}
							}
						}
					}
				}
				_tmp40_ = self->priv->db;
				_tmp41_ = sqlite3_errcode (_tmp40_);
				if (_tmp41_ != SQLITE_OK) {
					gint _tmp42_;
					sqlite3_stmt* _tmp43_;
					const gchar* _tmp44_;
					sqlite3* _tmp45_;
					const gchar* _tmp46_;
					GError* _tmp47_;
					_tmp42_ = i;
					_tmp43_ = self->priv->statement;
					_tmp44_ = sqlite3_sql (_tmp43_);
					_tmp45_ = self->priv->db;
					_tmp46_ = sqlite3_errmsg (_tmp45_);
					_tmp47_ = g_error_new (RYGEL_DATABASE_DATABASE_ERROR, RYGEL_DATABASE_DATABASE_ERROR_BIND, "Failed to bind value %d in %s: %s", _tmp42_, _tmp44_, _tmp46_);
					_inner_error_ = _tmp47_;
					if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			}
		}
	}
}


/**
     * Check if the cursor has more rows left
     *
     * @return true if more rows left, false otherwise
     */
gboolean rygel_database_cursor_has_next (RygelDatabaseCursor* self, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gint _tmp3_;
	gboolean _tmp6_ = FALSE;
	gint _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->dirty;
	if (_tmp0_) {
		sqlite3_stmt* _tmp1_;
		gint _tmp2_;
		_tmp1_ = self->priv->statement;
		_tmp2_ = sqlite3_step (_tmp1_);
		self->priv->current_state = _tmp2_;
		self->priv->dirty = FALSE;
	}
	_tmp3_ = self->priv->current_state;
	rygel_database_cursor_throw_if_code_is_error (self, _tmp3_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			gboolean _tmp4_ = FALSE;
			g_propagate_error (error, _inner_error_);
			return _tmp4_;
		} else {
			gboolean _tmp5_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp5_;
		}
	}
	_tmp7_ = self->priv->current_state;
	if (_tmp7_ == SQLITE_ROW) {
		_tmp6_ = TRUE;
	} else {
		gint _tmp8_;
		_tmp8_ = self->priv->current_state;
		_tmp6_ = _tmp8_ == -1;
	}
	result = _tmp6_;
	return result;
}


/**
     * Get the next row of this cursor.
     *
     * This function uses pointers instead of unowned because var doesn't work
     * with unowned.
     *
     * @return a pointer to the current row
     */
sqlite3_stmt* rygel_database_cursor_next (RygelDatabaseCursor* self, GError** error) {
	sqlite3_stmt* result = NULL;
	gint _tmp0_;
	sqlite3_stmt* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	rygel_database_cursor_has_next (self, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = self->priv->current_state;
	rygel_database_cursor_throw_if_code_is_error (self, _tmp0_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	self->priv->dirty = TRUE;
	_tmp1_ = self->priv->statement;
	result = _tmp1_;
	return result;
}


/**
     * Return an iterator to the cursor to use with foreach
     *
     * @return an iterator wrapping the cursor
     */
RygelDatabaseCursorIterator* rygel_database_cursor_iterator (RygelDatabaseCursor* self) {
	RygelDatabaseCursorIterator* result = NULL;
	RygelDatabaseCursorIterator* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = rygel_database_cursor_iterator_new (self);
	result = _tmp0_;
	return result;
}


/**
     * Convert a SQLite return code to a DatabaseError
     */
void rygel_database_cursor_throw_if_code_is_error (RygelDatabaseCursor* self, gint sqlite_error, GError** error) {
	gint _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = sqlite_error;
	switch (_tmp0_) {
		case SQLITE_OK:
		case SQLITE_DONE:
		case SQLITE_ROW:
		{
			return;
		}
		default:
		{
			gint _tmp1_;
			sqlite3* _tmp2_;
			const gchar* _tmp3_;
			GError* _tmp4_;
			_tmp1_ = sqlite_error;
			_tmp2_ = self->priv->db;
			_tmp3_ = sqlite3_errmsg (_tmp2_);
			_tmp4_ = g_error_new (RYGEL_DATABASE_DATABASE_ERROR, RYGEL_DATABASE_DATABASE_ERROR_SQLITE_ERROR, "SQLite error %d: %s", _tmp1_, _tmp3_);
			_inner_error_ = _tmp4_;
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
}


/**
     * Check if the last operation on the database was an error
     */
void rygel_database_cursor_throw_if_db_has_error (RygelDatabaseCursor* self, GError** error) {
	sqlite3* _tmp0_;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->db;
	_tmp1_ = sqlite3_errcode (_tmp0_);
	rygel_database_cursor_throw_if_code_is_error (self, _tmp1_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelDatabaseCursorIterator* rygel_database_cursor_iterator_construct (GType object_type, RygelDatabaseCursor* cursor) {
	RygelDatabaseCursorIterator* self = NULL;
	RygelDatabaseCursor* _tmp0_;
	RygelDatabaseCursor* _tmp1_;
	g_return_val_if_fail (cursor != NULL, NULL);
	self = (RygelDatabaseCursorIterator*) g_type_create_instance (object_type);
	_tmp0_ = cursor;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->cursor);
	self->cursor = _tmp1_;
	return self;
}


RygelDatabaseCursorIterator* rygel_database_cursor_iterator_new (RygelDatabaseCursor* cursor) {
	return rygel_database_cursor_iterator_construct (RYGEL_DATABASE_CURSOR_TYPE_ITERATOR, cursor);
}


gboolean rygel_database_cursor_iterator_next (RygelDatabaseCursorIterator* self, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	RygelDatabaseCursor* _tmp1_;
	gboolean _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->cursor;
	_tmp2_ = rygel_database_cursor_has_next (_tmp1_, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			gboolean _tmp3_ = FALSE;
			g_propagate_error (error, _inner_error_);
			return _tmp3_;
		} else {
			gboolean _tmp4_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp4_;
		}
	}
	result = _tmp0_;
	return result;
}


sqlite3_stmt* rygel_database_cursor_iterator_get (RygelDatabaseCursorIterator* self, GError** error) {
	sqlite3_stmt* result = NULL;
	sqlite3_stmt* _tmp0_ = NULL;
	RygelDatabaseCursor* _tmp1_;
	sqlite3_stmt* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->cursor;
	_tmp2_ = rygel_database_cursor_next (_tmp1_, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp0_;
	return result;
}


static void rygel_database_cursor_value_iterator_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_database_cursor_value_iterator_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_database_cursor_iterator_unref (value->data[0].v_pointer);
	}
}


static void rygel_database_cursor_value_iterator_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_database_cursor_iterator_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_database_cursor_value_iterator_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_database_cursor_value_iterator_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelDatabaseCursorIterator * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_database_cursor_iterator_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_database_cursor_value_iterator_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelDatabaseCursorIterator ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_database_cursor_iterator_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_database_cursor_param_spec_iterator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelDatabaseCursorParamSpecIterator* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_DATABASE_CURSOR_TYPE_ITERATOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_database_cursor_value_get_iterator (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_DATABASE_CURSOR_TYPE_ITERATOR), NULL);
	return value->data[0].v_pointer;
}


void rygel_database_cursor_value_set_iterator (GValue* value, gpointer v_object) {
	RygelDatabaseCursorIterator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_DATABASE_CURSOR_TYPE_ITERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_DATABASE_CURSOR_TYPE_ITERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_database_cursor_iterator_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_database_cursor_iterator_unref (old);
	}
}


void rygel_database_cursor_value_take_iterator (GValue* value, gpointer v_object) {
	RygelDatabaseCursorIterator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_DATABASE_CURSOR_TYPE_ITERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_DATABASE_CURSOR_TYPE_ITERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_database_cursor_iterator_unref (old);
	}
}


static void rygel_database_cursor_iterator_class_init (RygelDatabaseCursorIteratorClass * klass) {
	rygel_database_cursor_iterator_parent_class = g_type_class_peek_parent (klass);
	((RygelDatabaseCursorIteratorClass *) klass)->finalize = rygel_database_cursor_iterator_finalize;
}


static void rygel_database_cursor_iterator_instance_init (RygelDatabaseCursorIterator * self) {
	self->ref_count = 1;
}


static void rygel_database_cursor_iterator_finalize (RygelDatabaseCursorIterator * obj) {
	RygelDatabaseCursorIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_DATABASE_CURSOR_TYPE_ITERATOR, RygelDatabaseCursorIterator);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->cursor);
}


GType rygel_database_cursor_iterator_get_type (void) {
	static volatile gsize rygel_database_cursor_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_database_cursor_iterator_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_database_cursor_value_iterator_init, rygel_database_cursor_value_iterator_free_value, rygel_database_cursor_value_iterator_copy_value, rygel_database_cursor_value_iterator_peek_pointer, "p", rygel_database_cursor_value_iterator_collect_value, "p", rygel_database_cursor_value_iterator_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelDatabaseCursorIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_database_cursor_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDatabaseCursorIterator), 0, (GInstanceInitFunc) rygel_database_cursor_iterator_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_database_cursor_iterator_type_id;
		rygel_database_cursor_iterator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelDatabaseCursorIterator", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_database_cursor_iterator_type_id__volatile, rygel_database_cursor_iterator_type_id);
	}
	return rygel_database_cursor_iterator_type_id__volatile;
}


gpointer rygel_database_cursor_iterator_ref (gpointer instance) {
	RygelDatabaseCursorIterator * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_database_cursor_iterator_unref (gpointer instance) {
	RygelDatabaseCursorIterator * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_DATABASE_CURSOR_ITERATOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void rygel_database_cursor_class_init (RygelDatabaseCursorClass * klass) {
	rygel_database_cursor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelDatabaseCursorPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_database_cursor_finalize;
}


static void rygel_database_cursor_instance_init (RygelDatabaseCursor * self) {
	self->priv = RYGEL_DATABASE_CURSOR_GET_PRIVATE (self);
	self->priv->current_state = -1;
	self->priv->dirty = TRUE;
}


static void rygel_database_cursor_finalize (GObject * obj) {
	RygelDatabaseCursor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_DATABASE_TYPE_CURSOR, RygelDatabaseCursor);
	_sqlite3_finalize0 (self->priv->statement);
	G_OBJECT_CLASS (rygel_database_cursor_parent_class)->finalize (obj);
}


GType rygel_database_cursor_get_type (void) {
	static volatile gsize rygel_database_cursor_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_database_cursor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelDatabaseCursorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_database_cursor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDatabaseCursor), 0, (GInstanceInitFunc) rygel_database_cursor_instance_init, NULL };
		GType rygel_database_cursor_type_id;
		rygel_database_cursor_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelDatabaseCursor", &g_define_type_info, 0);
		g_once_init_leave (&rygel_database_cursor_type_id__volatile, rygel_database_cursor_type_id);
	}
	return rygel_database_cursor_type_id__volatile;
}



