// =============================================================================
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2005-2008 - INRIA - Pierre MARECHAL <pierre.marechal@inria.fr>
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

// <-- CLI SHELL MODE -->

// <-- Non-regression test for bug 557 -->
//
// <-- Bugzilla URL -->
// http://bugzilla.scilab.org/show_bug.cgi?id=557
//
// <-- Short Description -->
//    mprintf and diary don't work together
//    after each character of the string generated by
//    mprintf a newline character is inserted

// Create a ref file
prompt_str = prompt();
l = ["";prompt_str + "mprintf(""hello world\n"")";"hello world";"";prompt_str + "diary(TMPDIR+""/bug557.dia"", ""close"");"];
mputl(l, TMPDIR+'/bug557.ref');

//create a diary file
diary(TMPDIR+"/bug557.dia");
mprintf("hello world\n")
diary(TMPDIR+"/bug557.dia", "close");

//compare two files
ref = mgetl(TMPDIR+"/bug557.ref");
dia = mgetl(TMPDIR+"/bug557.dia");

assert_checkequal(ref, dia);
