/* ====================================================================
 * Copyright (c) 2009       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#include "ProjectItemTest.h"

// cppunit
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>

// sc
#include "subcommander/Project.h"


void ProjectItemTest::setUp()
{
}

void ProjectItemTest::tearDown()
{
}

void ProjectItemTest::testCreateSubItem()
{
  Project::Item item;

  Project::SubItem subItem0 = item.createSubItem();
  CPPUNIT_ASSERT( !subItem0.isNull() );
  CPPUNIT_ASSERT_EQUAL( true, subItem0.getPath().isEmpty() );

  Project::SubItem subItem1 = item.createSubItem();
  CPPUNIT_ASSERT( !subItem1.isNull() );
  CPPUNIT_ASSERT_EQUAL( true, subItem1.getPath().isEmpty() );

  CPPUNIT_ASSERT( subItem0.getId() != subItem1.getId() );
}

void ProjectItemTest::testEqualItem()
{
  Project::Item item1;
  Project::Item item2;

  Project::SubItem subItem = item1.createSubItem();
  item2 = item1;

  Project::SubItems items;
  item2.getSubItems(items);
  CPPUNIT_ASSERT_EQUAL( 1L, (long)items.size() );
  CPPUNIT_ASSERT( subItem == items[0] );
  
  CPPUNIT_ASSERT( item1 == item2 );
}
