# -*- coding: utf-8 -*-
#
# LLDB documentation build configuration file, created by
# sphinx-quickstart on Sun Dec  9 20:01:55 2012.
#
# This file is execfile()d with the current directory set to its containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.
from __future__ import print_function

import sys, os, re, shutil
from datetime import date

building_man_page = tags.has("builder-man")

# For the website we need to setup the path to the generated LLDB module that
# we can generate documentation for its API.
if not building_man_page:
    # If extensions (or modules to document with autodoc) are in another directory,
    # add these directories to sys.path here. If the directory is relative to the
    # documentation root, use os.path.abspath to make it absolute, like shown here.

    # Add the current directory that contains the mock _lldb native module which
    # is imported by the `lldb` module.
    sys.path.insert(0, os.path.abspath("."))
    # Add the build directory that contains the `lldb` module. LLDB_SWIG_MODULE is
    # set by CMake.
    sys.path.insert(0, os.getenv("LLDB_SWIG_MODULE"))

# Put the generated Python API documentation in the 'python_api' folder. This
# also defines the URL these files will have in the generated website.
automodapi_toctreedirnm = "python_api"

# -- General configuration -----------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be extensions
# coming with Sphinx (named 'sphinx.ext.*') or your custom ones.
extensions = ["sphinx.ext.todo", "sphinx.ext.mathjax", "sphinx.ext.intersphinx"]

autodoc_default_options = {
    "special-members": "__int__, __len__, __hex__, __oct__, __iter__",
}

# Unless we only generate the basic manpage we need the plugin for generating
# the Python API documentation.
if not building_man_page:
    extensions.append("sphinx_automodapi.automodapi")

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# The suffix of source filenames.
source_suffix = {
    ".rst": "restructuredtext",
}

# The encoding of source files.
# source_encoding = 'utf-8-sig'

# The master toctree document.
master_doc = "index"

# General information about the project.
project = "LLDB"
copyright = "2007-%d, The LLDB Team" % date.today().year

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents. These are currently set to zero because we don't use them.
# Should somebody consider in the future to change them, they need to be updated
# everytime a new release comes out.
#
# The short version.
# version = '0'
# The full version, including alpha/beta/rc tags.
# release = '0'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
# language = None

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
# today = ''
# Else, today_fmt is used as the format for a strftime call.
# today_fmt = '%B %d, %Y'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
exclude_patterns = ["_build", "analyzer"]
# Ignore the generated Python documentation that is only used on the website.
# Without this we will get a lot of warnings about doc pages that aren't
# included by any doctree (as the manpage ignores those pages but they are
# potentially still around from a previous website generation).
if building_man_page:
    exclude_patterns.append(automodapi_toctreedirnm)
# Use the recommended 'any' rule so that referencing SB API classes is possible
# by just writing `SBData`.
default_role = "any"

# If true, '()' will be appended to :func: etc. cross-reference text.
# add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
# add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
# show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = "friendly"

# A list of ignored prefixes for module index sorting.
# modindex_common_prefix = []


# -- Options for HTML output ---------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
html_theme = "alabaster"

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
html_theme_options = {
    "font_size": "11pt",
    # Don't generate any links to GitHub.
    "github_button": "false",
}

# Add any paths that contain custom themes here, relative to this directory.
# html_theme_path = []

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
html_title = "The LLDB Debugger"

# A shorter title for the navigation bar.  Default is the same as html_title.
# html_short_title = None

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
# html_logo = None

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
# html_favicon = None

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ["_static"]

html_context = {
    "css_files": ["_static/lldb.css"],
}

html_extra_path = [".htaccess"]

# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
html_last_updated_fmt = "%b %d, %Y"

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
# html_use_smartypants = True

# Custom sidebar templates, maps document names to template names.
# html_sidebars = {}

# Additional templates that should be rendered to pages, maps page names to
# template names.
# html_additional_pages = {}

# If false, no module index is generated.
# html_domain_indices = True

# If false, no index is generated.
# html_use_index = True

# If true, the index is split into individual pages for each letter.
# html_split_index = False

# If true, links to the reST sources are added to the pages.
# html_show_sourcelink = True

# If true, "Created using Sphinx" is shown in the HTML footer. Default is True.
# html_show_sphinx = True

# If true, "(C) Copyright ..." is shown in the HTML footer. Default is True.
# html_show_copyright = True

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
# html_use_opensearch = ''

# This is the file name suffix for HTML files (e.g. ".xhtml").
# html_file_suffix = None

# Output file base name for HTML help builder.
htmlhelp_basename = "LLDBdoc"

# If true, the reST sources are included in the HTML build as
# _sources/name. The default is True.
html_copy_source = False

# -- Options for LaTeX output --------------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #'papersize': 'letterpaper',
    # The font size ('10pt', '11pt' or '12pt').
    #'pointsize': '10pt',
    # Additional stuff for the LaTeX preamble.
    #'preamble': '',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title, author, documentclass [howto/manual]).
latex_documents = [
    ("index", "LLDB.tex", "LLDB Documentation", "The LLDB Team", "manual"),
]

# The name of an image file (relative to this directory) to place at the top of
# the title page.
# latex_logo = None

# For "manual" documents, if this is true, then toplevel headings are parts,
# not chapters.
# latex_use_parts = False

# If true, show page references after internal links.
# latex_show_pagerefs = False

# If true, show URL addresses after external links.
# latex_show_urls = False

# Documents to append as an appendix to all manuals.
# latex_appendices = []

# If false, no module index is generated.
# latex_domain_indices = True


# -- Options for manual page output --------------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    ("man/lldb", "lldb", "LLDB Documentation", ["LLVM project"], 1),
    ("man/lldb-server", "lldb-server", "LLDB Documentation", ["LLVM project"], 1),
]

# If true, show URL addresses after external links.
# man_show_urls = False

# -- Options for Texinfo output ------------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (
        "index",
        "LLDB",
        "LLDB Documentation",
        "The LLDB Team",
        "LLDB",
        "One line description of project.",
        "Miscellaneous",
    ),
]

# Documents to append as an appendix to all manuals.
# texinfo_appendices = []

# If false, no module index is generated.
# texinfo_domain_indices = True

# How to display URL addresses: 'footnote', 'no', or 'inline'.
# texinfo_show_urls = 'footnote'

empty_attr_summary = re.compile(
    r"\.\. rubric:: Attributes Summary\s*\.\. autosummary::\s*\.\. rubric::"
)
empty_attr_documentation = re.compile(
    r"\.\. rubric:: Attributes Documentation\s*\.\. rubric::"
)


def preprocess_source(app, docname, source):
    """Preprocesses source files generated by automodapi."""
    # Don't cleanup anything beside automodapi-generated sources.
    if not automodapi_toctreedirnm in docname:
        return
    processed = source[0]

    # Don't show the list of inheritance info as there is no inheritance in the
    # SBI API. This avoids all the repeated text on all doc pages that a
    # class inherits from 'object'.

    processed = processed.replace(":show-inheritance:", "")
    # Remove the SWIG generated 'thisown' attribute. It just bloats the generated
    # documentation and users shouldn't fiddle with the value anyway.
    processed = re.sub(r"~SB[a-zA-Z]+\.thisown", "", processed)
    processed = processed.replace("  .. autoattribute:: thisown", "")

    # After removing 'thisown', many objects don't have any attributes left.
    # Remove all now empty attribute summary/documentation sections with
    # some rather ugly regex.
    processed = empty_attr_summary.sub(".. rubric::", processed)
    processed = empty_attr_documentation.sub(".. rubric::", processed)

    # Replace the original source with the processed one (source is a single
    # element list).
    source[0] = processed


def cleanup_source(app, exception):
    """Remove files generated by automodapi in the source tree."""
    if hasattr(app.config, "automodapi_toctreedirnm"):
        api_source_dir = os.path.join(app.srcdir, app.config.automodapi_toctreedirnm)
        shutil.rmtree(api_source_dir, ignore_errors=True)


def setup(app):
    app.connect("source-read", preprocess_source)
    app.connect("build-finished", cleanup_source)
