/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.BgChar;
import com.dickimawbooks.texparserlib.Macro;
import com.dickimawbooks.texparserlib.MathBg;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import java.io.IOException;

public class EgChar
extends Macro {
    private int charCode;

    public EgChar() {
        this(125);
    }

    public EgChar(int n) {
        this.charCode = n;
    }

    @Override
    public Object clone() {
        return new EgChar(this.charCode);
    }

    public int getCharCode() {
        return this.charCode;
    }

    @Override
    public String format() {
        return String.format("%c", this.charCode);
    }

    @Override
    public String toString(TeXParser teXParser) {
        return String.format("%c", teXParser.getEgChar());
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(teXParser.getListener().getOther(this.charCode));
        return teXObjectList;
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        throw new TeXSyntaxException(teXParser, "tex.error.unexpected_eg", new Object[0]);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        throw new TeXSyntaxException(teXParser, "tex.error.unexpected_eg", new Object[0]);
    }

    public String show(TeXParser teXParser) throws IOException {
        return String.format("end-group character %c", this.charCode);
    }

    public boolean matches(BgChar bgChar) {
        return !(bgChar instanceof MathBg);
    }
}

