/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TeXUnit;
import java.io.IOException;

public class FixedUnit
extends TeXUnit {
    private int id;
    public static final int UNIT_PT = 0;
    public static final int UNIT_PC = 1;
    public static final int UNIT_IN = 2;
    public static final int UNIT_BP = 3;
    public static final int UNIT_CM = 4;
    public static final int UNIT_MM = 5;
    public static final int UNIT_DD = 6;
    public static final int UNIT_CC = 7;
    public static final int UNIT_SP = 8;
    public static final String[] UNIT_NAMES = new String[]{"pt", "pc", "in", "bp", "cm", "mm", "dd", "cc", "sp"};
    public static final float[] PT_FACTORS = new float[]{1.0f, 12.0f, 72.27f, 1.00375f, 28.452755f, 2.8452756f, 1.0700086f, 12.840104f, 1.5258789E-5f};

    public FixedUnit() {
        this(0);
    }

    public FixedUnit(int n) {
        if (n < 0 || n >= UNIT_NAMES.length) {
            throw new IllegalArgumentException(String.format("Invalid ID '%d' in FixedUnit(int)", n));
        }
        this.id = n;
    }

    public FixedUnit(String string) {
        this.id = -1;
        for (int i = 0; i < UNIT_NAMES.length; ++i) {
            if (!UNIT_NAMES[i].equals(string)) continue;
            this.id = i;
            break;
        }
        if (this.id == -1) {
            throw new IllegalArgumentException(String.format("Invalid unit name '%s' in FixedUnit(String)", string));
        }
    }

    @Override
    public Object clone() {
        return new FixedUnit(this.id);
    }

    public int getId() {
        return this.id;
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        return teXParser.string(this.toString());
    }

    @Override
    public String toString(TeXParser teXParser) {
        return this.toString();
    }

    @Override
    public String format() {
        return UNIT_NAMES[this.id];
    }

    @Override
    public float toPt(TeXParser teXParser, float f) throws TeXSyntaxException {
        return this.id == 0 ? f : f * PT_FACTORS[this.id];
    }

    @Override
    public float fromPt(TeXParser teXParser, float f) throws TeXSyntaxException {
        return this.id == 0 ? f : f / PT_FACTORS[this.id];
    }

    @Override
    public float toUnit(TeXParser teXParser, float f, TeXUnit teXUnit) throws TeXSyntaxException {
        if (this.equals(teXUnit)) {
            return f;
        }
        return this.fromPt(teXParser, teXUnit.toPt(teXParser, f));
    }

    @Override
    public float fromUnit(TeXParser teXParser, float f, TeXUnit teXUnit) throws TeXSyntaxException {
        return teXUnit.toUnit(teXParser, f, this);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        teXParser.getListener().getWriteable().write(UNIT_NAMES[this.id]);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.process(teXParser);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof FixedUnit)) {
            return false;
        }
        return this.id == ((FixedUnit)object).getId();
    }
}

