/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.BgChar;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.EgChar;
import com.dickimawbooks.texparserlib.EndDeclaration;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.NumericRegister;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.TeXCellAlignList;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXPath;
import com.dickimawbooks.texparserlib.TeXSettings;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TeXUnit;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.Writeable;
import com.dickimawbooks.texparserlib.aux.AuxData;
import com.dickimawbooks.texparserlib.aux.AuxParser;
import com.dickimawbooks.texparserlib.generic.DefaultTeXParserListener;
import com.dickimawbooks.texparserlib.latex.AbstractDec;
import com.dickimawbooks.texparserlib.latex.AddContentsLine;
import com.dickimawbooks.texparserlib.latex.AlignRow;
import com.dickimawbooks.texparserlib.latex.AtAlph;
import com.dickimawbooks.texparserlib.latex.AtFirstOfOne;
import com.dickimawbooks.texparserlib.latex.AtFirstOfTwo;
import com.dickimawbooks.texparserlib.latex.AtFnSymbol;
import com.dickimawbooks.texparserlib.latex.AtGobble;
import com.dickimawbooks.texparserlib.latex.AtGobbleTwo;
import com.dickimawbooks.texparserlib.latex.AtIfNextChar;
import com.dickimawbooks.texparserlib.latex.AtRoman;
import com.dickimawbooks.texparserlib.latex.AtSecondOfTwo;
import com.dickimawbooks.texparserlib.latex.Begin;
import com.dickimawbooks.texparserlib.latex.BibItem;
import com.dickimawbooks.texparserlib.latex.Bibliography;
import com.dickimawbooks.texparserlib.latex.BibliographyStyle;
import com.dickimawbooks.texparserlib.latex.Centerline;
import com.dickimawbooks.texparserlib.latex.Cite;
import com.dickimawbooks.texparserlib.latex.Cline;
import com.dickimawbooks.texparserlib.latex.Cr;
import com.dickimawbooks.texparserlib.latex.DescriptionDec;
import com.dickimawbooks.texparserlib.latex.DescriptionItem;
import com.dickimawbooks.texparserlib.latex.DocumentClass;
import com.dickimawbooks.texparserlib.latex.DocumentStyle;
import com.dickimawbooks.texparserlib.latex.End;
import com.dickimawbooks.texparserlib.latex.EnsureMath;
import com.dickimawbooks.texparserlib.latex.EnumerateDec;
import com.dickimawbooks.texparserlib.latex.FontFamilyDeclaration;
import com.dickimawbooks.texparserlib.latex.FontShapeDeclaration;
import com.dickimawbooks.texparserlib.latex.FontSizeDeclaration;
import com.dickimawbooks.texparserlib.latex.FontWeightDeclaration;
import com.dickimawbooks.texparserlib.latex.Footnote;
import com.dickimawbooks.texparserlib.latex.Frac;
import com.dickimawbooks.texparserlib.latex.GenericError;
import com.dickimawbooks.texparserlib.latex.Hline;
import com.dickimawbooks.texparserlib.latex.IfFileExists;
import com.dickimawbooks.texparserlib.latex.Ignorespaces;
import com.dickimawbooks.texparserlib.latex.Index;
import com.dickimawbooks.texparserlib.latex.IndexLocation;
import com.dickimawbooks.texparserlib.latex.IndexRoot;
import com.dickimawbooks.texparserlib.latex.Input;
import com.dickimawbooks.texparserlib.latex.InputIfFileExists;
import com.dickimawbooks.texparserlib.latex.ItemizeDec;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXCls;
import com.dickimawbooks.texparserlib.latex.LaTeXFile;
import com.dickimawbooks.texparserlib.latex.LaTeXGenericCommand;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.Label;
import com.dickimawbooks.texparserlib.latex.ListDec;
import com.dickimawbooks.texparserlib.latex.ListItem;
import com.dickimawbooks.texparserlib.latex.MakeAtLetter;
import com.dickimawbooks.texparserlib.latex.MakeAtOther;
import com.dickimawbooks.texparserlib.latex.MakeIndex;
import com.dickimawbooks.texparserlib.latex.MathDeclaration;
import com.dickimawbooks.texparserlib.latex.MathFontCommand;
import com.dickimawbooks.texparserlib.latex.MultiColumn;
import com.dickimawbooks.texparserlib.latex.NameRef;
import com.dickimawbooks.texparserlib.latex.NewCommand;
import com.dickimawbooks.texparserlib.latex.Obsolete;
import com.dickimawbooks.texparserlib.latex.PackageError;
import com.dickimawbooks.texparserlib.latex.PageRef;
import com.dickimawbooks.texparserlib.latex.Protect;
import com.dickimawbooks.texparserlib.latex.Ref;
import com.dickimawbooks.texparserlib.latex.StoreDataCs;
import com.dickimawbooks.texparserlib.latex.Tabular;
import com.dickimawbooks.texparserlib.latex.TabularNewline;
import com.dickimawbooks.texparserlib.latex.TextBlockCommand;
import com.dickimawbooks.texparserlib.latex.Thanks;
import com.dickimawbooks.texparserlib.latex.Today;
import com.dickimawbooks.texparserlib.latex.TrivListDec;
import com.dickimawbooks.texparserlib.latex.UnknownCls;
import com.dickimawbooks.texparserlib.latex.UnknownReference;
import com.dickimawbooks.texparserlib.latex.UnknownSty;
import com.dickimawbooks.texparserlib.latex.UseCounter;
import com.dickimawbooks.texparserlib.latex.UsePackage;
import com.dickimawbooks.texparserlib.latex.Verb;
import com.dickimawbooks.texparserlib.latex.Verbatim;
import com.dickimawbooks.texparserlib.latex.amsmath.AmsSymbSty;
import com.dickimawbooks.texparserlib.latex.amsmath.AmsmathSty;
import com.dickimawbooks.texparserlib.latex.booktabs.BooktabsSty;
import com.dickimawbooks.texparserlib.latex.bpchem.BpChemSty;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolBaseSty;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolSty;
import com.dickimawbooks.texparserlib.latex.etoolbox.EtoolboxSty;
import com.dickimawbooks.texparserlib.latex.fontenc.FontEncSty;
import com.dickimawbooks.texparserlib.latex.fourier.FourierSty;
import com.dickimawbooks.texparserlib.latex.graphics.GraphicsSty;
import com.dickimawbooks.texparserlib.latex.hyperref.HyperrefSty;
import com.dickimawbooks.texparserlib.latex.ifthen.IfThenSty;
import com.dickimawbooks.texparserlib.latex.inputenc.InputEncSty;
import com.dickimawbooks.texparserlib.latex.jmlr.Jmlr2eSty;
import com.dickimawbooks.texparserlib.latex.jmlr.JmlrBookCls;
import com.dickimawbooks.texparserlib.latex.jmlr.JmlrCls;
import com.dickimawbooks.texparserlib.latex.lipsum.LipsumSty;
import com.dickimawbooks.texparserlib.latex.mhchem.MhchemSty;
import com.dickimawbooks.texparserlib.latex.mnsymbol.MnSymbolSty;
import com.dickimawbooks.texparserlib.latex.natbib.NatbibSty;
import com.dickimawbooks.texparserlib.latex.pifont.PifontSty;
import com.dickimawbooks.texparserlib.latex.probsoln.ProbSolnSty;
import com.dickimawbooks.texparserlib.latex.shortvrb.DocSty;
import com.dickimawbooks.texparserlib.latex.shortvrb.ShortVrbSty;
import com.dickimawbooks.texparserlib.latex.shortvrb.VerbChar;
import com.dickimawbooks.texparserlib.latex.siunitx.SIunitxSty;
import com.dickimawbooks.texparserlib.latex.stix.StixSty;
import com.dickimawbooks.texparserlib.latex.tcilatex.BF;
import com.dickimawbooks.texparserlib.latex.tcilatex.NEG;
import com.dickimawbooks.texparserlib.latex.tcilatex.QABOVE;
import com.dickimawbooks.texparserlib.latex.tcilatex.QATOP;
import com.dickimawbooks.texparserlib.latex.tcilatex.QATOPD;
import com.dickimawbooks.texparserlib.latex.tcilatex.QDABOVE;
import com.dickimawbooks.texparserlib.latex.tcilatex.QDATOP;
import com.dickimawbooks.texparserlib.latex.tcilatex.QDATOPD;
import com.dickimawbooks.texparserlib.latex.tcilatex.QDOVERD;
import com.dickimawbooks.texparserlib.latex.tcilatex.QOVERD;
import com.dickimawbooks.texparserlib.latex.tcilatex.QTABOVE;
import com.dickimawbooks.texparserlib.latex.tcilatex.QTATOP;
import com.dickimawbooks.texparserlib.latex.tcilatex.QTATOPD;
import com.dickimawbooks.texparserlib.latex.tcilatex.QTOVERD;
import com.dickimawbooks.texparserlib.latex.tcilatex.Qcb;
import com.dickimawbooks.texparserlib.latex.tcilatex.SWFrame;
import com.dickimawbooks.texparserlib.latex.tcilatex.SWSpecialListener;
import com.dickimawbooks.texparserlib.latex.textcase.TextCaseSty;
import com.dickimawbooks.texparserlib.latex.textcomp.TextCompSty;
import com.dickimawbooks.texparserlib.latex.tipa.TipaSty;
import com.dickimawbooks.texparserlib.latex.upgreek.UpGreekSty;
import com.dickimawbooks.texparserlib.latex.wasysym.WasysymSty;
import com.dickimawbooks.texparserlib.latex.xspace.XspaceSty;
import com.dickimawbooks.texparserlib.primitives.Lowercase;
import com.dickimawbooks.texparserlib.primitives.NewIf;
import com.dickimawbooks.texparserlib.primitives.Undefined;
import com.dickimawbooks.texparserlib.primitives.Uppercase;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.file.Path;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class LaTeXParserListener
extends DefaultTeXParserListener {
    private Vector<String> verbEnv;
    private Vector<LaTeXFile> loadedPackages;
    private Vector<AuxData> auxData;
    private Hashtable<String, Vector<String>> counters;
    private LaTeXFile docCls;
    private TeXObjectList graphicsPath = null;
    private boolean docEnvFound = false;
    private String inputEncoding = null;
    private FontEncSty fontEncSty = null;
    private boolean parseAux = false;
    private TeXObjectList bibliographySection;
    private TeXObjectList footnotes;
    private Hashtable<String, IndexRoot> indexes;
    private String mainIndex = "main";
    private boolean indexingEnabled = false;
    private Stack<TrivListDec> trivListStack = new Stack();
    public static final UserNumber ZERO = new UserNumber(0);
    public static final UserNumber ONE = new UserNumber(1);
    public static final UserNumber MINUS_ONE = new UserNumber(-1);
    public static final String[] IMAGE_EXT = new String[]{"pdf", "PDF", "png", "PNG", "jpg", "JPG", "jpeg", "JPEG", "eps", "EPS", "ps", "PS", "gif", "GIF"};
    public static final Pattern PTSIZE_PATTERN = Pattern.compile("(\\d+)pt");

    public LaTeXParserListener(Writeable writeable) {
        this(writeable, null, false);
    }

    public LaTeXParserListener(Writeable writeable, boolean bl) {
        this(writeable, null, true);
    }

    public LaTeXParserListener(Writeable writeable, Vector<AuxData> vector) {
        this(writeable, vector, false);
    }

    public LaTeXParserListener(Writeable writeable, Vector<AuxData> vector, boolean bl) {
        super(writeable);
        this.setAuxData(vector);
        this.setParseAuxEnabled(bl);
        this.counters = new Hashtable();
        this.indexes = new Hashtable();
        this.footnotes = new TeXObjectList();
        this.loadedPackages = new Vector();
        this.verbEnv = new Vector();
    }

    public boolean isParseAuxEnabled() {
        return this.parseAux;
    }

    public void setParseAuxEnabled(boolean bl) {
        this.parseAux = bl;
    }

    public TeXObject getCitation(TeXObject teXObject) throws IOException {
        if (this.auxData == null) {
            return this.createUnknownReference(teXObject);
        }
        return AuxData.getCitation(this.auxData, this.getParser(), teXObject);
    }

    public TeXObject getReference(TeXObject teXObject) throws IOException {
        if (this.auxData == null) {
            return this.createUnknownReference(teXObject);
        }
        return AuxData.getReference(this.auxData, this.getParser(), teXObject);
    }

    public TeXObject getPageReference(TeXObject teXObject) throws IOException {
        if (this.auxData == null) {
            return this.createUnknownReference(teXObject);
        }
        return AuxData.getPageReference(this.auxData, this.getParser(), teXObject);
    }

    public TeXObject getNameReference(TeXObject teXObject) throws IOException {
        if (this.auxData == null) {
            return this.createUnknownReference(teXObject);
        }
        return AuxData.getNameReference(this.auxData, this.getParser(), teXObject);
    }

    public TeXObject getHyperReference(TeXObject teXObject) throws IOException {
        if (this.auxData == null) {
            return this.createUnknownReference(teXObject);
        }
        return AuxData.getHyperReference(this.auxData, this.getParser(), teXObject);
    }

    public TeXObject getLabelForLink(TeXObject teXObject) throws IOException {
        if (this.auxData == null) {
            return null;
        }
        return AuxData.getLabelForLink(this.auxData, this.getParser(), teXObject);
    }

    public void addVerbEnv(String string) {
        this.verbEnv.add(string);
    }

    public boolean isVerbEnv(String string) {
        return this.verbEnv.contains(string);
    }

    public boolean containsVerbatim(TeXObject object) {
        if (object instanceof VerbChar) {
            return true;
        }
        if (object instanceof ControlSequence) {
            return this.getParser().isVerbCommand(((ControlSequence)object).getName());
        }
        if (object instanceof TeXObjectList) {
            TeXObjectList teXObjectList = (TeXObjectList)object;
            for (int i = 0; i < teXObjectList.size(); ++i) {
                Object object2;
                object = (TeXObject)teXObjectList.get(i);
                if (object instanceof TeXObjectList) {
                    if (!this.containsVerbatim((TeXObject)object)) continue;
                    return true;
                }
                if (!(object instanceof ControlSequence)) continue;
                ControlSequence controlSequence = (ControlSequence)object;
                String string = controlSequence.getName();
                if (this.getParser().isVerbCommand(string)) {
                    return true;
                }
                if (!string.equals("begin")) continue;
                ++i;
                object = null;
                while (i < teXObjectList.size()) {
                    object2 = (TeXObject)teXObjectList.get(i);
                    ++i;
                    if (object2 instanceof Ignoreable) continue;
                    object = object2;
                    break;
                }
                if (object == null) {
                    return false;
                }
                if (object instanceof Group) {
                    object = ((Group)object).toList();
                } else if (object instanceof BgChar) {
                    object2 = new TeXObjectList();
                    ++i;
                    while (i < teXObjectList.size()) {
                        object = (TeXObject)teXObjectList.get(i);
                        ++i;
                        if (object instanceof EgChar) break;
                        ((TeXObjectList)object2).add((TeXObject)object);
                    }
                    object = object2;
                }
                object2 = object.toString(this.getParser());
                if (!this.isVerbEnv((String)object2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void addPredefined() {
        super.addPredefined();
        this.addVerbEnv("verbatim");
        this.addVerbEnv("verbatim*");
        this.addVerbEnv("filecontents");
        this.addVerbEnv("filecontents*");
        this.parser.putControlSequence(new Begin());
        this.parser.putControlSequence(new End());
        this.parser.putControlSequence(new DocumentClass());
        this.parser.putControlSequence(new UsePackage());
        this.parser.putControlSequence(new NewCommand());
        this.parser.putControlSequence(new NewCommand("renewcommand", 1));
        this.parser.putControlSequence(new NewCommand("providecommand", 2));
        this.parser.putControlSequence(new Label());
        this.parser.putControlSequence(new Ref());
        this.parser.putControlSequence(new PageRef());
        this.parser.putControlSequence(new NameRef());
        this.parser.putControlSequence(new Input());
        this.parser.putControlSequence(new InputIfFileExists());
        this.parser.putControlSequence(new IfFileExists());
        this.parser.putControlSequence(new MakeAtLetter());
        this.parser.putControlSequence(new MakeAtOther());
        this.parser.putControlSequence(new Ignorespaces());
        this.parser.putControlSequence(new Centerline());
        this.parser.putControlSequence(new Verb());
        this.parser.putControlSequence(new Cr("\\"));
        this.parser.putControlSequence(new Cr("cr"));
        this.parser.putControlSequence(new TabularNewline());
        this.parser.putControlSequence(new MultiColumn());
        this.parser.putControlSequence(new Hline());
        this.parser.putControlSequence(new Cline());
        this.parser.putControlSequence(new EnsureMath());
        this.parser.putControlSequence(new Frac());
        this.parser.putControlSequence(new GenericCommand("@empty"));
        this.parser.putControlSequence(new AtIfNextChar());
        this.parser.putControlSequence(new AtFirstOfTwo());
        this.parser.putControlSequence(new AtSecondOfTwo());
        this.parser.putControlSequence(new AtFirstOfOne());
        this.parser.putControlSequence(new AtGobble());
        this.parser.putControlSequence(new AtGobbleTwo());
        this.parser.putControlSequence(new AtAlph("@Alph", 0));
        this.parser.putControlSequence(new AtAlph("@alph", 1));
        this.parser.putControlSequence(new AtRoman("@Roman", 0));
        this.parser.putControlSequence(new AtRoman("@roman", 1));
        this.parser.putControlSequence(new Verbatim());
        this.parser.putControlSequence(new Verbatim("verbatim*"));
        this.parser.putControlSequence(new Tabular());
        this.parser.putControlSequence(new Tabular("array"));
        this.parser.putControlSequence(new Bibliography());
        this.parser.putControlSequence(new BibliographyStyle());
        this.parser.putControlSequence(new BibItem());
        this.parser.putControlSequence(new Cite());
        this.parser.putControlSequence(new AddContentsLine());
        this.parser.putControlSequence(new Uppercase("MakeUppercase"));
        this.parser.putControlSequence(new Lowercase("MakeLowercase"));
        this.parser.putControlSequence(new Protect());
        this.parser.putControlSequence(new Index());
        this.parser.putControlSequence(new MakeIndex());
        this.bibliographySection = new TeXObjectList();
        this.bibliographySection.add(new TeXCsRef("section"));
        this.bibliographySection.add(this.getOther(42));
        this.bibliographySection.add(new TeXCsRef("refname"));
        this.parser.putControlSequence(new GenericCommand("refname", null, this.createString("References")));
        this.parser.putControlSequence(new GenericCommand("contentsname", null, this.createString("Contents")));
        this.parser.putControlSequence(new GenericCommand("abstractname", null, this.createString("Abstract")));
        this.parser.putControlSequence(new AbstractDec());
        this.parser.putControlSequence(new Today());
        this.parser.putControlSequence(new StoreDataCs("title"));
        this.parser.putControlSequence(new StoreDataCs("author"));
        this.parser.putControlSequence(new StoreDataCs("date"));
        this.parser.putControlSequence(new GenericCommand("@date", null, new TeXCsRef("today")));
        this.parser.putControlSequence(new GenericCommand("figurename", null, this.createString("Figure")));
        this.parser.putControlSequence(new GenericCommand("tablename", null, this.createString("Table")));
        this.newlength("tabcolsep", 6.0f, TeXUnit.PT);
        this.newlength("arraycolsep", 5.0f, TeXUnit.PT);
        this.newtoks(true, "toks@");
        this.newcounter("part");
        this.newcounter("section");
        this.newcounter("subsection", "section");
        this.newcounter("subsubsection", "subsection");
        this.newcounter("paragraph", "subsubsection");
        this.newcounter("subparagraph", "paragraph");
        this.newcounter("part*");
        this.newcounter("section*");
        this.newcounter("subsection*", "section*");
        this.newcounter("subsubsection*", "subsection*");
        this.newcounter("paragraph*", "subsubsection*");
        this.newcounter("subparagraph*", "paragraph*");
        this.newcounter("figure");
        this.newcounter("table");
        this.newcounter("equation");
        this.newcounter("enumi");
        this.newcounter("enumii", null, "@alph");
        this.newcounter("enumiii", null, "@roman");
        this.newcounter("enumiv", null, "@Alph");
        this.newcounter("footnote");
        this.newcounter("mpfootnote");
        this.parser.getSettings().newcount("@listdepth");
        this.parser.getSettings().newcount("@enumdepth");
        this.parser.getSettings().newcount("@itemdepth");
        NewIf.createConditional(true, this.parser, "if@nmbrlist");
        this.parser.putControlSequence(new TrivListDec());
        this.parser.putControlSequence(new ListDec());
        this.parser.putControlSequence(new EnumerateDec());
        this.parser.putControlSequence(new ItemizeDec());
        this.parser.putControlSequence(new DescriptionDec());
        this.parser.putControlSequence(new GenericCommand(false, "descriptionlabel", new TeXObject[]{this.getParam(1)}, new TeXObject[]{new TeXCsRef("hspace"), new TeXCsRef("labelsep"), new TeXCsRef("normalfont"), new TeXCsRef("bfseries"), this.getParam(1)}));
        this.parser.putControlSequence(new ListItem());
        this.parser.putControlSequence(new DescriptionItem());
        this.parser.putControlSequence(new UseCounter());
        this.parser.putControlSequence(new GenericCommand(true, "labelenumi", null, new TeXObject[]{new TeXCsRef("theenumi"), this.getOther(46)}));
        this.parser.putControlSequence(new GenericCommand(true, "labelenumii", null, new TeXObject[]{this.getOther(40), new TeXCsRef("theenumii"), this.getOther(41)}));
        this.parser.putControlSequence(new GenericCommand(true, "labelenumiii", null, new TeXObject[]{new TeXCsRef("theenumiii"), this.getOther(46)}));
        this.parser.putControlSequence(new GenericCommand(true, "labelenumiv", null, new TeXObject[]{new TeXCsRef("theenumiv"), this.getOther(46)}));
        this.parser.putControlSequence(new GenericCommand(true, "labelitemi", null, new TeXObject[]{new TeXCsRef("textbullet")}));
        this.parser.putControlSequence(new GenericCommand(true, "labelitemii", null, new TeXObject[]{new TeXCsRef("normalfont"), new TeXCsRef("bfseries"), new TeXCsRef("textendash")}));
        this.parser.putControlSequence(new GenericCommand(true, "labelitemiii", null, new TeXObject[]{new TeXCsRef("textasteriskcentered")}));
        this.parser.putControlSequence(new GenericCommand(true, "labelitemiv", null, new TeXObject[]{new TeXCsRef("textperiodcentered")}));
        this.parser.putControlSequence(new GenericCommand("@mpfn", null, this.createString("footnote")));
        this.parser.putControlSequence(new GenericCommand("thempfn", null, new TeXCsRef("thefootnote")));
        this.parser.putControlSequence(new Footnote());
        this.parser.putControlSequence(new Thanks());
        this.parser.putControlSequence(new AtFnSymbol());
        this.parser.putControlSequence(new MathDeclaration("math"));
        MathDeclaration mathDeclaration = new MathDeclaration("(");
        this.parser.putControlSequence(mathDeclaration);
        this.parser.putControlSequence(new EndDeclaration(")", mathDeclaration));
        this.parser.putControlSequence(new MathDeclaration("displaymath", 2));
        MathDeclaration mathDeclaration2 = new MathDeclaration("[", 2);
        this.parser.putControlSequence(mathDeclaration2);
        this.parser.putControlSequence(new EndDeclaration("]", mathDeclaration2));
        this.parser.putControlSequence(new MathDeclaration("equation", 2, true));
        this.addMathFontCommand("mathrm", 0);
        this.addMathFontCommand("mathsf", 1);
        this.addMathFontCommand("mathtt", 2);
        this.addMathFontCommand("mathit", 3);
        this.addMathFontCommand("mathbf", 4);
        this.addMathFontCommand("mathcal", 5);
        this.addMathFontCommand("mathbb", 6);
        this.addMathFontCommand("mathfrak", 7);
        this.addMathFontCommand("boldsymbol", 8);
        this.addMathFontCommand("pmb", 9);
        this.addFontWeightDeclaration("mdseries", "textmd", 0);
        this.addFontWeightDeclaration("bfseries", "textbf", 1);
        this.addFontFamilyDeclaration("rmfamily", "textrm", 0);
        this.addFontFamilyDeclaration("sffamily", "textsf", 1);
        this.addFontFamilyDeclaration("ttfamily", "texttt", 2);
        this.addFontShapeDeclaration("upshape", "textup", 0);
        this.addFontShapeDeclaration("itshape", "textit", 1);
        this.addFontShapeDeclaration("slshape", "textsl", 2);
        this.addFontShapeDeclaration("scshape", "textsc", 4);
        this.addFontSizeDeclaration("normalsize", 0);
        this.addFontSizeDeclaration("large", 1);
        this.addFontSizeDeclaration("Large", 2);
        this.addFontSizeDeclaration("LARGE", 3);
        this.addFontSizeDeclaration("huge", 4);
        this.addFontSizeDeclaration("Huge", 5);
        this.addFontSizeDeclaration("HUGE", 6);
        this.addFontSizeDeclaration("small", 7);
        this.addFontSizeDeclaration("footnotesize", 8);
        this.addFontSizeDeclaration("scriptsize", 9);
        this.addFontSizeDeclaration("tiny", 10);
        this.parser.putControlSequence(new GenericCommand(true, "@spaces", null, new TeXObject[]{new TeXCsRef("space"), new TeXCsRef("space"), new TeXCsRef("space"), new TeXCsRef("space")}));
        this.parser.putControlSequence(new GenericError());
        this.parser.putControlSequence(new PackageError());
        this.parser.putControlSequence(new PackageError("PackageErrorNoLine", "latex.package.error"));
        this.parser.putControlSequence(new PackageError("ClassError", "latex.class.error"));
        this.parser.putControlSequence(new PackageError("ClassErrorNoLine", "latex.class.error"));
        this.parser.putControlSequence(new DocumentStyle());
    }

    protected void addMathFontCommand(String string, int n) {
        this.parser.putControlSequence(new MathFontCommand(string, n));
    }

    public void registerControlSequence(LaTeXSty laTeXSty, ControlSequence controlSequence) {
        this.parser.putControlSequence(controlSequence);
    }

    public void newcommand(byte by, String string, String string2, boolean bl, int n, TeXObject teXObject, TeXObject teXObject2) throws IOException {
        ControlSequence controlSequence = this.getControlSequence(string2);
        if (controlSequence instanceof Undefined) {
            if (by == 1) {
                throw new TeXSyntaxException(this.parser, "tex.error.undefined", String.format("%c%s", this.parser.getEscChar(), string2));
            }
        } else {
            if (by == 0) {
                throw new LaTeXSyntaxException(this.parser, "latex.error.defined", controlSequence.toString(this.parser));
            }
            if (by == 2) {
                return;
            }
        }
        this.addLaTeXCommand(string2, bl, n, teXObject, teXObject2);
    }

    public void addLaTeXCommand(String string, boolean bl, int n, TeXObject teXObject, TeXObject teXObject2) throws IOException {
        TeXObjectList teXObjectList;
        if (teXObject2 instanceof TeXObjectList) {
            teXObjectList = (TeXObjectList)teXObject2;
        } else {
            teXObjectList = new TeXObjectList(1);
            teXObjectList.add(teXObject2);
        }
        if (n == 0) {
            this.putControlSequence(true, new LaTeXGenericCommand(bl, string, teXObjectList));
            return;
        }
        char[] cArray = new char[n];
        cArray[0] = teXObject == null ? 109 : 111;
        for (int i = 1; i < n; ++i) {
            cArray[i] = 109;
        }
        if (teXObject == null) {
            this.putControlSequence(true, new LaTeXGenericCommand(bl, string, cArray, teXObjectList));
        } else {
            this.putControlSequence(true, new LaTeXGenericCommand(bl, string, cArray, teXObjectList, new TeXObject[]{teXObject}));
        }
    }

    private void addFontWeightDeclaration(String string, String string2, int n) {
        FontWeightDeclaration fontWeightDeclaration = this.getFontWeightDeclaration(string, n);
        this.parser.putControlSequence(fontWeightDeclaration);
        this.parser.putControlSequence(new TextBlockCommand(string2, fontWeightDeclaration));
    }

    private void addFontShapeDeclaration(String string, String string2, int n) {
        FontShapeDeclaration fontShapeDeclaration = this.getFontShapeDeclaration(string, n);
        this.parser.putControlSequence(fontShapeDeclaration);
        this.parser.putControlSequence(new TextBlockCommand(string2, fontShapeDeclaration));
    }

    private void addFontSizeDeclaration(String string, int n) {
        this.parser.putControlSequence(this.getFontSizeDeclaration(string, n));
    }

    private void addFontFamilyDeclaration(String string, String string2, int n) {
        FontFamilyDeclaration fontFamilyDeclaration = this.getFontFamilyDeclaration(string, n);
        this.parser.putControlSequence(fontFamilyDeclaration);
        this.parser.putControlSequence(new TextBlockCommand(string2, fontFamilyDeclaration));
    }

    @Override
    public ControlSequence getTeXFontFamilyDeclaration(String string, int n) {
        ControlSequence controlSequence = super.getTeXFontFamilyDeclaration(string, n);
        String string2 = controlSequence.getName() + "family";
        ControlSequence controlSequence2 = this.getControlSequence(string2);
        return controlSequence2 == null ? controlSequence : new Obsolete(controlSequence, controlSequence2);
    }

    @Override
    public ControlSequence getTeXFontWeightDeclaration(String string, int n) {
        ControlSequence controlSequence = super.getTeXFontWeightDeclaration(string, n);
        String string2 = controlSequence.getName() + "series";
        ControlSequence controlSequence2 = this.getControlSequence(string2);
        return controlSequence2 == null ? controlSequence : new Obsolete(controlSequence, controlSequence2);
    }

    @Override
    public ControlSequence getTeXFontShapeDeclaration(String string, int n) {
        if (string.equals("em")) {
            FontShapeDeclaration fontShapeDeclaration = this.getFontShapeDeclaration("em", 3);
            this.putControlSequence(new TextBlockCommand("emph", fontShapeDeclaration));
            return fontShapeDeclaration;
        }
        ControlSequence controlSequence = super.getTeXFontShapeDeclaration(string, n);
        String string2 = controlSequence.getName() + "shape";
        ControlSequence controlSequence2 = this.getControlSequence(string2);
        return controlSequence2 == null ? controlSequence : new Obsolete(controlSequence, controlSequence2);
    }

    public FontWeightDeclaration getFontWeightDeclaration(String string, int n) {
        return new FontWeightDeclaration(string, n);
    }

    public FontSizeDeclaration getFontSizeDeclaration(String string, int n) {
        return new FontSizeDeclaration(string, n);
    }

    public FontShapeDeclaration getFontShapeDeclaration(String string, int n) {
        return new FontShapeDeclaration(string, n);
    }

    public FontFamilyDeclaration getFontFamilyDeclaration(String string, int n) {
        return new FontFamilyDeclaration(string, n);
    }

    public UnknownReference createUnknownReference(String string) {
        return new UnknownReference((TeXParserListener)this, string);
    }

    public UnknownReference createUnknownReference(TeXObject teXObject) {
        return new UnknownReference((TeXParserListener)this, teXObject);
    }

    public TeXCellAlignList createTeXCellAlignList(TeXObject teXObject) throws IOException {
        return new TeXCellAlignList(this.getParser(), teXObject);
    }

    public boolean isInDocEnv() {
        return this.docEnvFound;
    }

    public void setIsInDocEnv(boolean bl) {
        this.docEnvFound = bl;
    }

    public void beginDocument() throws IOException {
        File file;
        if (this.isInDocEnv()) {
            throw new LaTeXSyntaxException(this.parser, "latex.error.multi_begin_doc", new Object[0]);
        }
        this.getParser().getSettings().setCharMapMode(0);
        this.setIsInDocEnv(true);
        if (this.isParseAuxEnabled() && (file = this.getAuxFile()) != null && file.exists()) {
            AuxParser auxParser = new AuxParser(this.getTeXApp(), this.getCharSet());
            auxParser.parseAuxFile(file);
            this.auxData = auxParser.getAuxData();
        }
    }

    public void endDocument() throws IOException {
        this.processFootnotes();
        if (!this.isInDocEnv()) {
            throw new LaTeXSyntaxException(this.parser, "latex.error.no_begin_doc", new Object[0]);
        }
        throw new EOFException();
    }

    public void processFootnotes() throws IOException {
        if (this.footnotes.size() > 0) {
            this.doFootnoteRule();
            while (this.footnotes.size() > 0) {
                this.footnotes.pop().process(this.getParser());
                this.getPar().process(this.getParser());
            }
        }
    }

    public void doFootnoteRule() throws IOException {
    }

    public LaTeXFile getDocumentClass() {
        return this.docCls;
    }

    public KeyValList getDocumentClassOptions() {
        return this.docCls == null ? null : this.docCls.getOptions();
    }

    public void documentclass(KeyValList keyValList, String string) throws IOException {
        if (this.docCls != null) {
            throw new LaTeXSyntaxException(this.parser, "latex.error.multi_cls", new Object[0]);
        }
        this.docCls = this.getLaTeXCls(keyValList, string);
        this.addFileReference(this.docCls);
    }

    public LaTeXCls getLaTeXCls(KeyValList keyValList, String string) throws IOException {
        if (string.equals("jmlr")) {
            return new JmlrCls(keyValList, this);
        }
        if (string.equals("jmlrbook")) {
            return new JmlrBookCls(keyValList, this);
        }
        return new UnknownCls(keyValList, string, this);
    }

    public void removePackage(LaTeXSty laTeXSty) {
        this.removeFileReference(laTeXSty);
        this.loadedPackages.remove(laTeXSty);
    }

    public LaTeXSty requirepackage(String string) throws IOException {
        LaTeXSty laTeXSty = this.getLoadedPackage(string);
        if (laTeXSty != null) {
            return laTeXSty;
        }
        laTeXSty = this.getLaTeXSty(null, string);
        this.addFileReference(laTeXSty);
        this.loadedPackages.add(laTeXSty);
        return laTeXSty;
    }

    public void usepackage(LaTeXSty laTeXSty) {
        if (this.isStyLoaded(laTeXSty.getName())) {
            this.removePackage(laTeXSty);
        }
        this.addFileReference(laTeXSty);
        this.loadedPackages.add(laTeXSty);
    }

    public LaTeXSty usepackage(KeyValList keyValList, String string) throws IOException {
        if (!this.isStyLoaded(string)) {
            LaTeXSty laTeXSty = this.getLaTeXSty(keyValList, string);
            this.addFileReference(laTeXSty);
            this.loadedPackages.add(laTeXSty);
            return laTeXSty;
        }
        return null;
    }

    public LaTeXSty getLoadedPackage(String string) {
        if (this.loadedPackages == null) {
            return null;
        }
        for (LaTeXFile laTeXFile : this.loadedPackages) {
            LaTeXSty laTeXSty;
            if (!(laTeXFile instanceof LaTeXSty) || !(laTeXSty = (LaTeXSty)laTeXFile).getName().equals(string)) continue;
            return laTeXSty;
        }
        return null;
    }

    public FontEncSty getFontEncSty() {
        return this.fontEncSty;
    }

    public LaTeXSty getLaTeXSty(KeyValList keyValList, String string) throws IOException {
        if (string.equals("graphics") || string.equals("graphicx") || string.equals("epsfig")) {
            if (string.equals("epsfig") && !this.isStyLoaded("graphicx")) {
                LaTeXFile laTeXFile = new LaTeXFile(this.parser, null, "graphicx", "sty");
                this.addFileReference(laTeXFile);
                this.loadedPackages.add(laTeXFile);
            }
            return new GraphicsSty(keyValList, string, this);
        }
        if (string.equals("amsmath")) {
            return new AmsmathSty(keyValList, string, this);
        }
        if (string.equals("amssymb")) {
            return new AmsSymbSty(keyValList, string, this);
        }
        if (string.equals("lipsum")) {
            return new LipsumSty(keyValList, this);
        }
        if (string.equals("etoolbox")) {
            return new EtoolboxSty(keyValList, this);
        }
        if (string.equals("hyperref")) {
            return new HyperrefSty(keyValList, this);
        }
        if (string.equals("inputenc")) {
            return new InputEncSty(keyValList, this);
        }
        if (string.equals("fontenc")) {
            this.fontEncSty = new FontEncSty(keyValList, this);
            return this.fontEncSty;
        }
        if (string.equals("natbib")) {
            return new NatbibSty(keyValList, this);
        }
        if (string.equals("wasysym")) {
            return new WasysymSty(keyValList, string, this);
        }
        if (string.equals("pifont")) {
            return new PifontSty(keyValList, string, this);
        }
        if (string.equals("booktabs")) {
            return new BooktabsSty(keyValList, string, this);
        }
        if (string.equals("textcase")) {
            return new TextCaseSty(keyValList, this);
        }
        if (string.equals("shortvrb")) {
            return new ShortVrbSty(keyValList, this);
        }
        if (string.equals("doc")) {
            return new DocSty(keyValList, this);
        }
        if (string.equals("probsoln")) {
            return new ProbSolnSty(keyValList, this);
        }
        if (string.equals("bpchem")) {
            return new BpChemSty(keyValList, this);
        }
        if (string.equals("siunitx")) {
            return new SIunitxSty(keyValList, this);
        }
        if (string.equals("mhchem")) {
            return new MhchemSty(keyValList, this);
        }
        if (string.equals("stix")) {
            return new StixSty(keyValList, this);
        }
        if (string.toLowerCase().equals("mnsymbol")) {
            return new MnSymbolSty(keyValList, this);
        }
        if (string.equals("textcomp")) {
            return new TextCompSty(keyValList, this);
        }
        if (string.equals("fourier")) {
            return new FourierSty(keyValList, this);
        }
        if (string.equals("upgreek")) {
            return new UpGreekSty(keyValList, this);
        }
        if (string.equals("tipa")) {
            return new TipaSty(keyValList, this);
        }
        if (string.equals("datatool")) {
            return new DataToolSty(keyValList, this);
        }
        if (string.equals("datatool-base")) {
            return new DataToolBaseSty(keyValList, this);
        }
        if (string.equals("ifthen")) {
            return new IfThenSty(keyValList, this);
        }
        if (string.equals("xspace")) {
            return new XspaceSty(keyValList, this);
        }
        if (string.equals("jmlr2e")) {
            return new Jmlr2eSty(keyValList, this);
        }
        return new UnknownSty(keyValList, string, this);
    }

    public abstract void substituting(String var1, String var2) throws IOException;

    public abstract void includegraphics(KeyValList var1, String var2) throws IOException;

    public boolean isStyLoaded(String string) {
        for (LaTeXFile laTeXFile : this.loadedPackages) {
            if (!laTeXFile.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public Vector<LaTeXFile> getLoadedPackages() {
        return this.loadedPackages;
    }

    @Override
    public boolean input(TeXPath teXPath) throws IOException {
        if (teXPath.toString().endsWith("tcilatex.tex")) {
            this.usepackage(null, "amsmath");
            this.usepackage(null, "graphicx");
            this.addSpecialListener(new SWSpecialListener());
            this.parser.putControlSequence(new SWFrame());
            this.parser.putControlSequence(new Qcb());
            this.parser.putControlSequence(new BF());
            this.parser.putControlSequence(new NEG());
            this.parser.putControlSequence(new QATOP());
            this.parser.putControlSequence(new QTATOP());
            this.parser.putControlSequence(new QDATOP());
            this.parser.putControlSequence(new QABOVE());
            this.parser.putControlSequence(new QTABOVE());
            this.parser.putControlSequence(new QDABOVE());
            this.parser.putControlSequence(new QOVERD());
            this.parser.putControlSequence(new QTOVERD());
            this.parser.putControlSequence(new QDOVERD());
            this.parser.putControlSequence(new QATOPD());
            this.parser.putControlSequence(new QTATOPD());
            this.parser.putControlSequence(new QDATOPD());
            return true;
        }
        return super.input(teXPath);
    }

    public boolean bibliography(TeXPath[] teXPathArray, TeXPath teXPath) throws IOException {
        return teXPath.exists() ? super.input(teXPath) : false;
    }

    @Override
    public Charset getCharSet() {
        Charset charset = null;
        if (this.inputEncoding != null && !this.inputEncoding.equals("utf8")) {
            try {
                charset = InputEncSty.getCharSet(this.inputEncoding);
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                this.getTeXApp().error(illegalCharsetNameException);
                charset = null;
            }
        }
        return charset;
    }

    public void setGraphicsPath(TeXObjectList teXObjectList) throws IOException {
        this.graphicsPath = teXObjectList;
    }

    public TeXObjectList getGraphicsPath() {
        return this.graphicsPath;
    }

    public String getInputEncoding() {
        return this.inputEncoding;
    }

    public void setInputEncoding(String string) {
        this.inputEncoding = string;
    }

    protected File getImageFile(String[] stringArray, TeXPath teXPath) throws IOException, InterruptedException {
        Object object;
        if (stringArray == null) {
            object = teXPath.getFile();
            if (((File)object).exists()) {
                return object;
            }
        } else {
            object = teXPath.getBaseDir();
            for (int i = 0; i < stringArray.length; ++i) {
                Path path = new File(File.separatorChar == '/' ? stringArray[i] : stringArray[i].replaceAll("/", File.separator)).toPath().resolve(teXPath.getRelative());
                File file = (object == null ? path : object.resolve(path)).toFile();
                if (!file.exists()) continue;
                return file;
            }
        }
        if ((object = this.getTeXApp().kpsewhich(teXPath.getFileName().toString())) != null && !((String)object).isEmpty()) {
            return new File((String)object);
        }
        return null;
    }

    public String[] getGraphicsPaths() throws IOException {
        TeXObjectList teXObjectList = this.getGraphicsPath();
        String[] stringArray = null;
        if (teXObjectList != null && teXObjectList.size() > 0) {
            int n = teXObjectList.size();
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                TeXObject teXObject = (TeXObject)teXObjectList.get(i);
                TeXObjectList teXObjectList2 = null;
                if (teXObject instanceof Expandable) {
                    teXObjectList2 = ((Expandable)((Object)teXObject)).expandfully(this.parser);
                }
                stringArray[i] = teXObjectList2 != null ? teXObjectList2.toString(this.parser) : teXObject.toString(this.parser);
            }
        }
        return stringArray;
    }

    public File getImage(String[] stringArray, String string) throws IOException {
        try {
            if (string.contains(".")) {
                TeXPath teXPath = new TeXPath(this.parser, string);
                return this.getImageFile(stringArray, teXPath);
            }
            for (int i = 0; i < IMAGE_EXT.length; ++i) {
                String string2 = string + "." + IMAGE_EXT[i];
                TeXPath teXPath = new TeXPath(this.parser, string2);
                File file = this.getImageFile(stringArray, teXPath);
                if (file == null) continue;
                return file;
            }
        }
        catch (InterruptedException interruptedException) {
            this.getTeXApp().error(interruptedException);
        }
        return null;
    }

    public void cr(boolean bl, TeXObject teXObject) throws IOException {
        TeXSettings teXSettings = this.getParser().getSettings();
        if (teXSettings.getAlignMode() == 1) {
            teXSettings.startRow();
        }
    }

    public AlignRow createAlignRow(TeXObjectList teXObjectList) throws IOException {
        return new AlignRow(this.getParser(), teXObjectList);
    }

    public void setAuxData(Vector<AuxData> vector) {
        this.auxData = vector;
    }

    public Vector<AuxData> getAuxData() {
        return this.auxData;
    }

    public File getAuxFile() {
        return this.getAuxFile("aux");
    }

    public File getBblFile() {
        return this.getAuxFile("bbl");
    }

    public File getAuxFile(String string) {
        if (this.getParser() == null) {
            return null;
        }
        File file = this.getParser().getCurrentParentFile();
        if (file == null) {
            return null;
        }
        String string2 = this.parser.getJobname();
        return new File(file, string2 + "." + string);
    }

    public void newcounter(String string) {
        this.newcounter(string, null);
    }

    public void newcounter(String string, String string2) {
        this.newcounter(string, string2, "number");
    }

    public void newcounter(String string, String string2, String string3) {
        this.parser.getSettings().newcount(false, "c@" + string);
        if (string2 == null) {
            this.parser.putControlSequence(new GenericCommand(true, "the" + string, null, new TeXObject[]{new TeXCsRef(string3), new TeXCsRef("c@" + string)}));
        } else {
            this.parser.putControlSequence(new GenericCommand(true, "the" + string, null, new TeXObject[]{new TeXCsRef("the" + string2), this.getOther(46), new TeXCsRef("number"), new TeXCsRef("c@" + string)}));
            this.addtoreset(string, string2);
        }
    }

    public void addtoreset(String string, String string2) {
        Vector<String> vector = this.counters.get(string2);
        if (vector == null) {
            vector = new Vector();
            this.counters.put(string2, vector);
        }
        vector.add(string);
    }

    public int getcountervalue(String string) throws TeXSyntaxException, LaTeXSyntaxException {
        NumericRegister numericRegister = this.parser.getSettings().getNumericRegister("c@" + string);
        if (numericRegister == null) {
            throw new LaTeXSyntaxException(this.parser, "latex.error.undefined_counter", string);
        }
        return numericRegister.number(this.parser);
    }

    public void addtocounter(String string, Numerical numerical) throws TeXSyntaxException {
        this.parser.getSettings().globalAdvanceRegister("c@" + string, numerical);
    }

    public void setcounter(String string, Numerical numerical) throws TeXSyntaxException {
        this.parser.getSettings().globalSetRegister("c@" + string, numerical);
    }

    public void resetcounter(String string) throws TeXSyntaxException {
        this.setcounter(string, ZERO);
    }

    public void stepcounter(String string) throws TeXSyntaxException {
        this.addtocounter(string, ONE);
        Vector<String> vector = this.counters.get(string);
        if (vector != null) {
            for (String string2 : vector) {
                this.resetcounter(string2);
            }
        }
    }

    public TeXObjectList getBibliographySection() {
        return this.bibliographySection;
    }

    public void setBibiographySection(TeXObjectList teXObjectList) {
        this.bibliographySection = teXObjectList;
    }

    public void addFootnote(TeXObject teXObject) {
        this.footnotes.add(teXObject);
    }

    public TeXObjectList getAuthor() {
        ControlSequence controlSequence = this.getControlSequence("@author");
        if (controlSequence instanceof GenericCommand) {
            return ((GenericCommand)controlSequence).getDefinition();
        }
        return null;
    }

    public IndexRoot getIndexRoot(String string) {
        if (!this.isIndexingEnabled()) {
            return null;
        }
        return this.indexes.get(string == null ? this.mainIndex : string);
    }

    public IndexLocation createIndexLocation(String string) throws IOException {
        return new IndexLocation(new TeXCsRef("thepage"));
    }

    public void index(String string, TeXObject teXObject) throws IOException {
        IndexRoot indexRoot = this.getIndexRoot(string);
        if (indexRoot != null) {
            indexRoot.addEntry(this.getParser(), teXObject, this.createIndexLocation(string == null ? this.mainIndex : string));
        }
    }

    @Override
    public float emToPt(float f) {
        KeyValList keyValList;
        this.getTeXApp().warning(this.getParser(), "Can't convert from em to pt, no font information loaded");
        float f2 = 10.0f;
        if (this.docCls == null && (keyValList = this.docCls.getOptions()) != null) {
            Iterator iterator = keyValList.keySet().iterator();
            while (iterator.hasNext()) {
                Matcher matcher = PTSIZE_PATTERN.matcher((CharSequence)iterator.next());
                if (!matcher.matches()) continue;
                try {
                    f2 = Integer.parseInt(matcher.group(1));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
        }
        return f2 * 0.95f * f;
    }

    @Override
    public float exToPt(float f) {
        KeyValList keyValList;
        this.getTeXApp().warning(this.getParser(), "Can't convert from ex to pt, no font information loaded");
        float f2 = 10.0f;
        if (this.docCls == null && (keyValList = this.docCls.getOptions()) != null) {
            Iterator iterator = keyValList.keySet().iterator();
            while (iterator.hasNext()) {
                Matcher matcher = PTSIZE_PATTERN.matcher((CharSequence)iterator.next());
                if (!matcher.matches()) continue;
                try {
                    f2 = Integer.parseInt(matcher.group(1));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
        }
        return f2 * 0.44f * f;
    }

    public boolean isIndexingEnabled() {
        return this.indexingEnabled;
    }

    public void enableIndexing(boolean bl) {
        this.enableIndexing(this.mainIndex, bl);
    }

    public void enableIndexing(String string, boolean bl) {
        IndexRoot indexRoot;
        this.indexingEnabled = bl;
        if (this.indexingEnabled && (indexRoot = this.getIndexRoot(string)) == null) {
            this.indexes.put(string == null ? this.mainIndex : string, indexRoot);
        }
    }

    public void setMainIndexLabel(String string) {
        this.mainIndex = string;
    }

    public void startList(TrivListDec trivListDec) throws IOException {
        this.trivListStack.push(trivListDec);
    }

    public void endList(TrivListDec trivListDec) throws IOException {
        this.trivListStack.pop();
    }

    public TrivListDec peekTrivListStack() {
        return this.trivListStack.peek();
    }
}

