/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.DimenRegister;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TeXUnit;
import com.dickimawbooks.texparserlib.UserDimension;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXFile;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import java.io.IOException;

public abstract class LaTeXSty
extends LaTeXFile {
    private String name;
    private LaTeXParserListener listener;

    public LaTeXSty(String string, LaTeXParserListener laTeXParserListener) throws IOException {
        this(null, string, "sty", laTeXParserListener);
    }

    public LaTeXSty(String string, String string2, LaTeXParserListener laTeXParserListener) throws IOException {
        this(null, string, string2, laTeXParserListener);
    }

    public LaTeXSty(KeyValList keyValList, String string, LaTeXParserListener laTeXParserListener) throws IOException {
        this(keyValList, string, "sty", laTeXParserListener);
    }

    public LaTeXSty(KeyValList keyValList, String string, String string2, LaTeXParserListener laTeXParserListener) throws IOException {
        super(laTeXParserListener.getParser(), keyValList, string, string2);
        this.name = string;
        this.listener = laTeXParserListener;
        if (keyValList != null) {
            this.load(keyValList);
        } else {
            this.preOptions();
            this.postOptions();
        }
    }

    public abstract void addDefinitions();

    public void registerControlSequence(ControlSequence controlSequence) {
        this.listener.registerControlSequence(this, controlSequence);
    }

    public DimenRegister registerNewLength(String string) {
        return this.listener.getParser().getSettings().newdimen(string);
    }

    public DimenRegister registerNewLength(String string, float f, TeXUnit teXUnit) {
        DimenRegister dimenRegister = this.registerNewLength(string);
        try {
            dimenRegister.setValue(this.listener.getParser(), new UserDimension(f, teXUnit));
        }
        catch (TeXSyntaxException teXSyntaxException) {
            // empty catch block
        }
        return dimenRegister;
    }

    public abstract void processOption(String var1) throws IOException;

    public void processOptions(KeyValList keyValList) throws IOException {
        if (keyValList == null) {
            return;
        }
        for (String string : keyValList.keySet()) {
            if (string == null || string.isEmpty()) continue;
            this.processOption(string);
        }
    }

    protected abstract void preOptions() throws IOException;

    protected void postOptions() throws IOException {
        this.addDefinitions();
    }

    public void load(KeyValList keyValList) throws IOException {
        this.preOptions();
        KeyValList keyValList2 = this.listener.getDocumentClassOptions();
        if (keyValList2 != keyValList) {
            this.processOptions(keyValList2);
        }
        this.processOptions(keyValList);
        this.postOptions();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof LaTeXSty)) {
            return false;
        }
        return this.name.equals(((LaTeXSty)object).getName());
    }

    public LaTeXParserListener getListener() {
        return this.listener;
    }

    public TeXParser getParser() {
        return this.listener.getParser();
    }
}

