---
myst:
  html_meta:
    keywords: LaTeX, fichiers, fontes, polices de caractères, polices postscript, polices T1,
              fontes T1, fichier de métriques
---

# Comment obtenir des fichier TFM pour des fontes de type 1 ?

Les fournisseurs de polices réputés tels qu'Adobe fournissent des fichiers métriques pour chaque police, 
sous la forme de fichier AFM (*Adobe Font Metric*). 
Ces fichiers peuvent être convertis au format TFM (*TeX Font Metric*). 
La plupart des distributions modernes ont des métriques pré-intégrées 
qui sont plus que suffisantes pour les besoins courants. 
Mais vous devrez peut-être faire la conversion vous-même 
si vous avez des besoins particuliers ou si vous acquérez une nouvelle fonte. 


## Avec des modifications d'encodage

Une question importante est le *codage* des fontes (de caractères latins). 
Si la position d'environ 96 caractères dans les fontes est stabilisée
(le jeu ASCII de base), la situation est bien différente sur le reste des 256 caractères. 
Les problèmes les plus évidents concernent les accents flottants 
et les caractères spéciaux tels que le signe "livre sterling". 
Il y a trois façons d'y remédier : 
- soit vous modifiez les commandes TeX qui font référence aux caractères 
  (ce qui est généralement rébarbatif et source d'erreurs) ; 
- soit vous modifiez l'encodage de la police (ce qui est plus facile que vous ne le pensez) ; 
- soit vous utilisez des [fontes virtuelles](/5_fichiers/formats/fontes/que_sont_les_fontes_virtuelles) 
  pour *faire croire* à TeX que l'encodage est le même que celui dont il a l'habitude. 
  LaTeX2e dispose de facilités pour traiter les polices dans des encodages différents. 
  Le *[LaTeX Companion](/1_generalites/documentation/livres/documents_sur_latex)* donne ici plus de détails. 
  En pratique, si vous faites beaucoup de composition non anglaise (mais en caractères latins), 
  il est fortement recommandé d'utiliser l'extension <ctanpkg:fontenc> avec l'option `T1` 
  pour sélectionner l'encodage de [Cork](/5_fichiers/formats/fontes/que_sont_les_fontes_ec)".

Une alternative privilégiée par certains est le codage `LY1` "privé" de Y&Y,
qui est conçu pour s'accorder avec les polices codées "standard Adobe". 
Des commandes pour LY1 sont d'ailleurs disponibles.
notez ici que l'utilisateur de LY1 n'a pas besoin de polices virtuelles du fait de l'encodage d'Adobe.


## Avec l'extension <ctanpkg:fontinst>

L'extension <ctanpkg:fontinst> d'Alan Jeffrey est un convertisseur AFM vers TFM écrit en TeX. 
Il est utilisé pour générer les fichiers utilisés par l'extension [PSNFSS](ctanpkg:psnfss) de LaTeX2e 
pour supporter l'utilisation des polices PostScript. 
Il s'agit d'une extension sophistiquée, qui n'est pas faite pour les débutants, 
mais qui est suffisamment puissant pour répondre à la plupart des besoins. 
Une grande partie de sa puissance repose sur l'utilisation 
de [fontes virtuelles](/5_fichiers/formats/fontes/que_sont_les_fontes_virtuelles).


## Avec le programme `afm2tfm`

Pour des problèmes un peu plus simples, `afm2tfm` de Rokicki, distribué avec `dvips`, est rapide et efficace. 
Notez que les métriques et les styles fournis avec `dvips` ne sont *pas* actuellement compatibles avec LaTeX2e.


## Avec le programme `EdMetrics`

Pour un ordinateur Mac, il existe un programme appelé `EdMetrics` qui fait le travail (et plus encore). 
Ce programme est fourni avec la distribution (commerciale) [Textures](/6_distributions/installation/implementations_commerciales),
mais reste bien un logiciel libre disponible sur CTAN.

:::{sources}
[TeX font metric files for Type 1 fonts](faquk:FAQ-metrics)
:::
