target=spline1 splinelagrange1

#if #TARGET(spline1)
\title{Interpolation par spline cubique (I)}
#endif
#if #TARGET(splinelagrange1)
\title{Interpolation : Comparaison (I)}
#endif
\integer{n=3} 
8 coefficients
conditions : 
\author{Bernadette Perrin-Riou}
\email{bpr@math.u-psud.fr}
\precision{1000}
\text{style = <style type="text/css">
 .question {
  background-color: #FFFFAA;
  margin : 2% 5%;
  padding : 2%;
  text-align: left;}
  .reponse {background-color : #ffcc99;
          color : black;
          margin : 2% 5%;
          padding : 2%;}
 </style>}
 
 
\text{S = 0,randint(50..79),randint(101..200)}
\text{S=pari(0.1*[\S])}
\real{t = \S[2]-\S[1]}
\real{u = \S[3]-\S[2]}

Approximation par splines :

\matrix{M = pari(M=matrix(8,8) ; 
M[1,4] =1 ; 
M[2,]  =[\t^3,\t^2,\t,1,0,0,0,0];
M[3,8] =1 ; 
M[4,]  =[0,0,0,0,\u^3,\u^2,\u,1];
M[5,]  =[3*\t^2,2*\t,1,0,0,0,-1,0];
M[6,]  =[6*\t,2,0,0,0,-2,0,0];
M[7,] =[0,2,0,0,0,0,0,0];
M[8,] =[0,0,0,0,6*\u,2,0,0] ; M)}
\text{H = randint(4..20),randint(40..50)}
\text{V =0,\H[1],\H[1],\H[2],0,0,0,0}
\matrix{N = pari(floor(10000*[\M]^(-1)*[\V]~)~*0.0001)}
\text{f1= \N[1]*t^3 + \N[2]*t^2 + \N[3]*t +\N[4] }
\text{f2= \N[5]*(t-\S[2])^3 + (\N[6])*(t-\S[2])^2 + (\N[7])*(t-\S[2]) +(\N[8]) }
\text{f1x= simplify(\N[1]*x^3 + (\N[2])*x^2 + (\N[3])*x + (\N[4]))}
\text{f2x= simplify(\N[5]*(x-\S[2])^3 + (\N[6])*(x-\S[2])^2 + (\N[7])*(x-\S[2]) +(\N[8])) }

\text{P1 = a_1 * (x-\S[1])^3 + b_1 * (x-\S[1])^2 + c_1 * (x-\S[1]) + d_1}
\text{P2 = a_2 * (x-\S[2])^3 + b_2 * (x-\S[2])^2 + c_2 * (x-\S[2]) + d_2}

\text{Mhtml=wims(rows2lines \M)}

#if #TARGET(splinelagrange1)
Approximation par lagrange
%%%%

text{P =b *x^2 + c *x + d}
\matrix{Ml = pari(M=matrix(3,3) ; 
  M[1,] = [(\S[1])^2,\S[1],1] ;
  M[2,] = [(\S[2])^2,\S[2],1] ; 
  M[3,] = [(\S[3])^2,\S[3],1] ; 
  M)}
\text{Vl =0,\H[1],\H[2]}
\matrix{Nl = pari(floor(10000*[\Ml]^(-1)*[\Vl]~)~*0.0001)}
\text{fl= \Nl[1]*t^2 + \Nl[2]*t + \Nl[3] }
#endif
%%%%
\text{Dessin=xrange -2,\S[3]*1.2
yrange -2,\H[2]*1.1
disk \S[1],0,7,green
disk \S[2],\H[1],7,green
disk \S[3],\H[2],7,green
dvline \S[2],0,red
dvline \S[3],0,red
hline 0,0,blue
trange \S[1],\S[2]
plot black,t,\f1
trange \S[2],\S[3]
plot blue,t,\f2
}
\text{enonce=
Dans le tableau suivant, voici quelques valeurs donnant la vitesse
d'un vhicule en acclration en fonction du temps. }


#if #TARGET(spline1)

\text{Dessin=draw(200,200
\Dessin)}


\text{enonce2=
On dsire interpoler ces points par une fonction "lisse", par exemple, c'est--dire trouver 
une fonction \(f) donnant la vitesse en fonction du temps qui soit
continue et drivable deux fois. Pour cela, comme dans le cas de l'approximation linaire,
on va chercher sur chacun des segments [\S[1],\S[2]] et [\S[2],\S[3]]
une fonction cubique : 
\(P_1 = \P1),  \(P_2 = \P2).  }

\steps{r1,r2,r3,r4,r5,r6,r7,r8
r9,r10}

\statement{
\style \enonce
<table align="center" border=1>
   <tr><th>Temps</th><td align="center">\S[1]</td><td align="center">\S[2]</td><td align="center">\S[3]</td></tr>
   <tr><th>Vitesse</th><td align="center">0</td><td align="center">\H[1]</td><td align="center">\H[2]</td></tr>
 </table>

 \enonce2
 
 \if{\step=1}{
<div class="question">Ecrire les coefficients du
systme linaire que vrifient les coefficients \(a_1, b_1, c_1, d_1,
a_2, b_2, c_2, d_2)
des deux polynmes cubiques \(P_1), \(P_2). </div>
<ol><li>
Condition au premier point : 
\embed{reply1}
</li>
<li>
Condition au deuxime point ( gauche) : 
\embed{reply2}
</li>
<li>
Condition au deuxime point ( droite) : 
\embed{reply3}
</li>
<li>
Condition au troisime point ( gauche) : 
\embed{reply4}
</li>
</ol>

<ol><li value=5>
Drivabilit au deuxime point : 
\embed{reply5}
</li>
</ol>
<ol><li value=6>
Drivabilit seconde au deuxime point : 
\embed{reply6}
</li>
</ol>

<ol><li value=7>
Drive seconde nulle au premier point : 
\embed{reply7}
</li>
<li value=8>
Drivabilit nulle au troisime point : 
\embed{reply8}
</li>
</ol>

}
\if{\step=2}{La matrice du systme est en effet 
<pre>
\special{expandlines \Mhtml}
</pre>
<div class="question">Rsoudre le systme et donner les polynmes solution : 
</div><ul> 
<li>\embed{reply9} sur [\S[1],\S[2]]</li>
<li>\embed{reply10} sur [\S[2],\S[3]]</li>
</ul>
</div>
}
<p align=center><img src=\Dessin></p>
}

\answer{}{\M[1;]}{type=vector}
\answer{}{\M[2;]}{type=vector}
\answer{}{\M[3;]}{type=vector}
\answer{}{\M[4;]}{type=vector}
\answer{}{\M[5;]}{type=vector}
\answer{}{\M[6;]}{type=vector}
\answer{}{\M[7;]}{type=vector}
\answer{}{\M[8;]}{type=vector}
\answer{}{\f1x,x}{type=function}
\answer{}{\f2x,x}{type=function}

#endif

#if #TARGET(splinelagrange1)
  \real{S0= randitem(randint(10*\S[1]+10 .. 10*\S[2]-10),randint(10*\S[2]+10 .. 10*\S[3]-10))/10}
  \real{Vlag= evalue(\fl,t=\S0)}
  \real{Vspline= \S0 < \S[2] ? evalue(\f1,t=\S0):evalue(\f2,t=\S0)}
 
 
\text{Dessin=draw(400,400
\Dessin
trange \S[1],\S[3]
plot purple,t,\fl
vline \S0,0,green)}


\statement{\style \enonce
<table align="center" border=1>
   <tr><th align="center">Temps</th><td align="center">\S[1]</td><td align="center">\S[2]</td>
   <td align="center">\S[3]</td></tr>
   <tr><th align="center">Vitesse</th><td align="center">0</td>
   <td align="center">\H[1]</td><td align="center">\H[2]</td></tr>
 </table>

 \enonce2
 
 Donner la vitesse en \(x = \S0) si l'on utilise une 
 <ul>
   <li>interpolation polynomiale de Lagrange : \embed{reply1} </li>
   <li>interpolation par des splines cubiques : \embed{reply2} </li>
 </ul>
<i> Pour l'interpolation par des splines, on imposera la drive seconde nulle
aux extrmits.</i>

<p align="center"><img src=\Dessin></p>
}
\answer{}{\Vlag}{type=numeric}
\answer{}{\Vspline}{type=numeric}
#endif
